/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.templates;

import java.util.HashMap;
import org.eclipse.datatools.sqltools.editor.template.SQLTemplate;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLDevToolsUIConfiguration;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLToolsUIFacade;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.ISQLCompletionProposal;
import org.eclipse.datatools.sqltools.sqleditor.internal.templates.Messages;
import org.eclipse.datatools.sqltools.sqleditor.internal.templates.PositionBasedCompletionProposal;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class SQLTemplateProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ISQLCompletionProposal {
    public static final String KEY_SQLEDITOR = "SQLEDITOR";
    private Template _template;
    private final TemplateContext _context;
    private final Image _image;
    private final IRegion _region;
    private int _relevance;
    private IRegion _selectedRegion;
    private String _displayString;
    private InclusivePositionUpdater _updater;
    private IInformationControlCreator _informationControlCreator;
    private SQLEditor _editor;
    private boolean inserted = false;
    private int _startOffset;
    private int _endOffset;
    private IPreferenceStore _preferenceStore = SQLEditorPlugin.getDefault().getPreferenceStore();
    private int count = 0;

    public SQLTemplateProposal(SQLEditor editor, Template template, TemplateContext context, IRegion region, Image image) {
        this(editor, template, context, region, image, 0);
    }

    public SQLTemplateProposal(SQLEditor editor, Template template, TemplateContext context, IRegion region, Image image, int relevance) {
        Assert.isNotNull((Object)template);
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)region);
        this._template = template;
        this._context = context;
        this._image = image;
        this._region = region;
        this._displayString = null;
        this._relevance = relevance;
        this._editor = editor;
    }

    public final void setInformationControlCreator(IInformationControlCreator informationControlCreator) {
        this._informationControlCreator = informationControlCreator;
    }

    protected final Template getTemplate() {
        return this._template;
    }

    protected final TemplateContext getContext() {
        return this._context;
    }

    public final void apply(IDocument document) {
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        if (this.inserted) {
            if (!this._editor.isConnected()) {
                this.inserted = false;
                return;
            }
            try {
                try {
                    TemplateBuffer templateBuffer = null;
                    TemplateVariable[] variables = null;
                    try {
                        templateBuffer = this._context.evaluate(this._template);
                        variables = templateBuffer.getVariables();
                    }
                    catch (BadLocationException e) {
                        SQLEditorPlugin.getDefault().log(e);
                    }
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    String word = "";
                    int offset1 = ((TextSelection)viewer.getSelectionProvider().getSelection()).getOffset();
                    if (variables != null) {
                        int i = 0;
                        while (i < variables.length) {
                            String text = viewer.getDocument().get();
                            word = this.findWord(text, offset1);
                            hashMap.put(variables[i].getName(), word);
                            ++i;
                        }
                    }
                    hashMap.put(KEY_SQLEDITOR, (Object)this._editor);
                    SQLDevToolsUIConfiguration configuration = SQLToolsUIFacade.getConfigurationByProfileName((String)this._editor.getDatabaseIdentifier().getProfileName());
                    SQLTemplate template = configuration.getTemplateService().getIntelligenceTemplate(((SQLTemplate)this._template).getId(), hashMap, this._editor.getDatabaseIdentifier());
                    this._preferenceStore.setValue("intelligence.template", template.getClass().getName());
                    if (template.getPattern() != null) {
                        this.insertTemplate(viewer, 0, this._startOffset, offset1, (Template)template);
                    }
                }
                catch (TemplateException e) {
                    this._selectedRegion = this._region;
                    SQLEditorPlugin.getDefault().log(e);
                }
                catch (Exception e) {
                    SQLEditorPlugin.getDefault().log(e);
                }
            }
            catch (Throwable throwable) {}
            this.inserted = false;
            return;
        }
        int start = this.getReplaceOffset();
        int end = Math.max(this.getReplaceEndOffset(), offset);
        this.insertTemplate(viewer, offset, start, end, this._template);
        this.inserted = true;
    }

    private void insertTemplate(ITextViewer viewer, int offset, int start, int end, Template template) {
        IDocument document = viewer.getDocument();
        try {
            TemplateBuffer templateBuffer;
            this._context.setReadOnly(false);
            try {
                templateBuffer = this._context.evaluate(template);
            }
            catch (TemplateException e) {
                this._selectedRegion = this._region;
                SQLEditorPlugin.getDefault().log(e);
                return;
            }
            String templateString = templateBuffer.getString();
            int documentlength = end - start;
            if (end - start > document.getLength() - start) {
                documentlength = document.getLength() - start;
            }
            document.replace(start, documentlength, templateString);
            this._startOffset = start;
            this._endOffset = start + templateString.length();
            LinkedModeModel model = new LinkedModeModel();
            TemplateVariable[] variables = templateBuffer.getVariables();
            boolean hasPositions = false;
            int i = 0;
            while (i != variables.length) {
                TemplateVariable variable = variables[i];
                if (!variable.isUnambiguous()) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int[] offsets = variable.getOffsets();
                    int length = variable.getLength();
                    String[] values = variable.getValues();
                    ICompletionProposal[] proposals = new ICompletionProposal[values.length];
                    int j = 0;
                    while (j < values.length) {
                        this.ensurePositionCategoryInstalled(document, model);
                        Position pos = new Position(offsets[0] + start, length);
                        document.addPosition(this.getCategory(), pos);
                        proposals[j] = new PositionBasedCompletionProposal(values[j], pos, length);
                        ++j;
                    }
                    j = 0;
                    while (j != offsets.length) {
                        if (j == 0 && proposals.length > 1) {
                            group.addPosition((LinkedPosition)new ProposalPosition(document, offsets[j] + start, length, proposals));
                        } else {
                            group.addPosition(new LinkedPosition(document, offsets[j] + start, length));
                        }
                        ++j;
                    }
                    model.addGroup(group);
                    hasPositions = true;
                }
                ++i;
            }
            if (hasPositions) {
                model.forceInstall();
                LinkedModeUI ui = new LinkedModeUI(model, viewer);
                ui.setExitPosition(viewer, this.getCaretOffset(templateBuffer) + start, 0, Integer.MAX_VALUE);
                ui.setDoContextInfo(true);
                ui.enter();
                this._selectedRegion = ui.getSelectedRegion();
            } else {
                this.ensurePositionCategoryRemoved(document);
                this._selectedRegion = new Region(this.getCaretOffset(templateBuffer) + start, 0);
            }
        }
        catch (BadLocationException e) {
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            SQLEditorPlugin.getDefault().log(e);
            this.ensurePositionCategoryRemoved(document);
            this._selectedRegion = this._region;
        }
        catch (BadPositionCategoryException e) {
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            SQLEditorPlugin.getDefault().log(e);
            this._selectedRegion = this._region;
        }
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this._updater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater((IPositionUpdater)this._updater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    SQLTemplateProposal.this.ensurePositionCategoryRemoved(document);
                    if (SQLTemplateProposal.this._template instanceof SQLTemplate) {
                        String id = ((SQLTemplate)SQLTemplateProposal.this._template).getId();
                        if (id.startsWith("intelligence.template") && SQLTemplateProposal.this.inserted) {
                            SQLTemplateProposal.this.apply((ITextViewer)SQLTemplateProposal.this._editor.getSV(), ' ', 0, 0);
                        }
                        SQLTemplateProposal sQLTemplateProposal = SQLTemplateProposal.this;
                        sQLTemplateProposal.count = sQLTemplateProposal.count + 1;
                        if (SQLTemplateProposal.this.count == 2) {
                            SQLTemplateProposal.this._preferenceStore.setValue("intelligence.template", "");
                        }
                    }
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater((IPositionUpdater)this._updater);
        }
    }

    private String getCategory() {
        return "TemplateProposalCategory_" + this.toString();
    }

    private int getCaretOffset(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (variable.getType().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    protected final int getReplaceOffset() {
        int start;
        if (this._context instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this._context;
            start = docContext.getStart();
        } else {
            start = this._region.getOffset();
        }
        return start;
    }

    protected final int getReplaceEndOffset() {
        int end;
        if (this._context instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this._context;
            end = docContext.getEnd();
        } else {
            end = this._region.getOffset() + this._region.getLength();
        }
        return end;
    }

    public Point getSelection(IDocument document) {
        return new Point(this._selectedRegion.getOffset(), this._selectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        TemplateBuffer templateBuffer;
        try {
            this._context.setReadOnly(true);
            try {
                templateBuffer = this._context.evaluate(this._template);
            }
            catch (TemplateException templateException) {
                return null;
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (this._template instanceof SQLTemplate && ((SQLTemplate)this._template).getId().startsWith("intelligence.template")) {
            String str = null;
            str = "<B><CENTER>" + this._template.getPattern() + "</B> </CENTER><BR>";
            str = String.valueOf(str) + Messages.SQLTemplateProposal_proposalInfo;
            str = String.valueOf(str) + "<B>" + ((SQLTemplate)this._template).getProposalPopupDescription() + "</B>";
            return str;
        }
        return templateBuffer.getString();
    }

    public String getDisplayString() {
        if (this._displayString == null) {
            Object[] arguments = new String[]{this._template.getName(), this._template.getDescription()};
            this._displayString = Messages.format(Messages.TemplateProposal_displayString, arguments);
        }
        return this._displayString;
    }

    public Image getImage() {
        return this._image;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private void openErrorDialog(Shell shell, Exception e) {
        MessageDialog.openError((Shell)shell, (String)Messages.TemplateProposal_errorDialog_title, (String)e.getMessage());
    }

    public int getRelevance() {
        return this._relevance;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return this._informationControlCreator;
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            int replaceOffset = this.getReplaceOffset();
            if (offset >= replaceOffset) {
                String content = document.get(replaceOffset, offset - replaceOffset);
                return this._template.getName().toLowerCase().startsWith(content.toLowerCase());
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this._template.getName();
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplaceOffset();
    }

    public void apply(IDocument document, char trigger, int offset) {
    }

    public boolean isValidFor(IDocument document, int offset) {
        return false;
    }

    public char[] getTriggerCharacters() {
        return new char[0];
    }

    public int getContextInformationPosition() {
        return this._region.getOffset();
    }

    private String findWord(String text, int offset) {
        int end = offset;
        int i = end - 1;
        while (i > 0) {
            if (text.charAt(i) == ' ' || text.charAt(i) == '\n' || text.charAt(i) == '\t') break;
            --end;
            --i;
        }
        return text.substring(end, offset);
    }
}

