/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards.mq;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.commands.extensions.mq.HgQInitClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.views.PatchQueueView;
import com.vectrace.MercurialEclipse.wizards.HgWizard;
import com.vectrace.MercurialEclipse.wizards.mq.Messages;
import com.vectrace.MercurialEclipse.wizards.mq.QInitWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;

public class QInitWizard
extends HgWizard {
    private QInitWizardPage page = null;
    private IResource resource;

    public QInitWizard(IResource resource) {
        super(Messages.getString("QInitWizard.title"));
        this.resource = resource;
        this.setNeedsProgressMonitor(true);
        this.page = new QInitWizardPage(Messages.getString("QInitWizard.pageName"), Messages.getString("QInitWizard.pageTitle"), null, null, resource);
        this.initPage(Messages.getString("QInitWizard.pageDescription"), this.page);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        InitOperation initOperation = new InitOperation((IRunnableContext)this.getContainer());
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)initOperation);
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            this.page.setErrorMessage(e.getLocalizedMessage());
            return false;
        }
        PatchQueueView.getView().populateTable();
        return true;
    }

    private class InitOperation
    extends HgOperation {
        public InitOperation(IRunnableContext context) {
            super(context);
        }

        protected String getActionDescription() {
            return Messages.getString("QInitWizard.InitAction.description");
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.getString("QInitWizard.beginTask"), 2);
            monitor.worked(1);
            monitor.subTask(Messages.getString("QInitWizard.subTask.callMercurial"));
            try {
                HgQInitClient.init(QInitWizard.this.resource, QInitWizard.this.page.getCheckBox().getSelection());
                monitor.worked(1);
                monitor.done();
            }
            catch (HgException e) {
                throw new InvocationTargetException((Throwable)((Object)e), e.getLocalizedMessage());
            }
        }
    }
}

