/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards.mq;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.commands.extensions.mq.HgQDeleteClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.views.PatchQueueView;
import com.vectrace.MercurialEclipse.wizards.HgWizard;
import com.vectrace.MercurialEclipse.wizards.mq.Messages;
import com.vectrace.MercurialEclipse.wizards.mq.QDeletePage;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;

public class QDeleteWizard
extends HgWizard {
    private QDeletePage page = null;
    private IResource resource;

    public QDeleteWizard(IResource resource) {
        super(Messages.getString("QDeleteWizard.title"));
        this.resource = resource;
        this.setNeedsProgressMonitor(true);
        this.page = new QDeletePage(Messages.getString("QDeleteWizard.pageName"), Messages.getString("QDeleteWizard.pageTitle"), null, Messages.getString("QDeleteWizard.pageDescription"), resource);
        this.initPage(Messages.getString("QDeleteWizard.pageDescription"), this.page);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        DeleteOperation delOperation = new DeleteOperation((IRunnableContext)this.getContainer());
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)delOperation);
            PatchQueueView.getView().populateTable();
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            this.page.setErrorMessage(e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private class DeleteOperation
    extends HgOperation {
        public DeleteOperation(IRunnableContext context) {
            super(context);
        }

        protected String getActionDescription() {
            return Messages.getString("QDeleteWizard.deleteAction.description");
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.getString("QDeleteWizard.deleteAction.beginTask"), 2);
            monitor.worked(1);
            monitor.subTask(Messages.getString("QDeleteWizard.subTask.callMercurial"));
            try {
                IStructuredSelection selection = (IStructuredSelection)QDeleteWizard.this.page.getPatchViewer().getSelection();
                List patches = selection.toList();
                HgQDeleteClient.delete(QDeleteWizard.this.resource, false, QDeleteWizard.this.page.getChangesetTable().getSelection(), patches);
                monitor.worked(1);
                monitor.done();
            }
            catch (HgException e) {
                throw new InvocationTargetException((Throwable)((Object)e), e.getLocalizedMessage());
            }
        }
    }
}

