/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards.mq;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.extensions.mq.HgQAppliedClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.Patch;
import com.vectrace.MercurialEclipse.ui.ChangesetTable;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.mq.Messages;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class QDeletePage
extends HgWizardPage {
    private IResource resource;
    private ListViewer patchViewer;
    private ChangesetTable changesetTable;
    private Button revCheckBox;
    private Button keepCheckBox;

    public QDeletePage(String pageName, String title, ImageDescriptor titleImage, String description, IResource resource) {
        super(pageName, title, titleImage, description);
        this.resource = resource;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTWidgetHelper.createComposite(parent, 2);
        Group g = SWTWidgetHelper.createGroup(composite, Messages.getString("QDeletePage.patchGroup.title"));
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        };
        this.patchViewer = SWTWidgetHelper.createListViewer((Composite)g, Messages.getString("QDeletePage.patchViewer.title"), 100, (IBaseLabelProvider)labelProvider);
        this.populatePatchViewer();
        g = SWTWidgetHelper.createGroup(composite, Messages.getString("QDeletePage.optionGroup.title"));
        this.keepCheckBox = SWTWidgetHelper.createCheckBox((Composite)g, Messages.getString("QDeletePage.keepCheckBox.title"));
        this.revCheckBox = SWTWidgetHelper.createCheckBox((Composite)g, Messages.getString("QDeletePage.revCheckBox.title"));
        SelectionListener revListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                QDeletePage.this.changesetTable.setEnabled(QDeletePage.this.revCheckBox.getSelection());
                QDeletePage.this.patchViewer.getControl().setEnabled(!QDeletePage.this.revCheckBox.getSelection());
            }
        };
        this.revCheckBox.addSelectionListener(revListener);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.minimumHeight = 50;
        this.changesetTable = new ChangesetTable((Composite)g, (IResource)this.resource.getProject());
        this.changesetTable.setLayoutData(gridData);
        this.changesetTable.setEnabled(false);
        this.setControl((Control)composite);
    }

    private void populatePatchViewer() {
        try {
            List<Patch> patches = HgQAppliedClient.getUnappliedPatches(this.resource);
            for (Patch patch : patches) {
                this.patchViewer.add((Object)patch);
            }
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
            this.setErrorMessage(e.getLocalizedMessage());
        }
    }

    public ListViewer getPatchViewer() {
        return this.patchViewer;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public Button getRevCheckBox() {
        return this.revCheckBox;
    }

    public Button getKeepCheckBox() {
        return this.keepCheckBox;
    }

    public ChangesetTable getChangesetTable() {
        return this.changesetTable;
    }
}

