/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.extensions.HgSignClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.ui.ChangesetTable;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SignWizardPage
extends HgWizardPage {
    private final IProject project;
    private Text userTextField;
    private Combo keyCombo;
    private Button localCheckBox;
    private Button forceCheckBox;
    private Button noCommitCheckBox;
    private ChangesetTable changesetTable;
    private Text messageTextField;
    private Text passTextField;
    private boolean gotGPGkeys;

    public SignWizardPage(String pageName, String title, ImageDescriptor titleImage, String description, IProject proj) {
        super(pageName, title, titleImage, description);
        this.project = proj;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTWidgetHelper.createComposite(parent, 2);
        Group changeSetGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("SignWizardPage.changeSetGroup.title"), 1808);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.minimumHeight = 50;
        this.changesetTable = new ChangesetTable((Composite)changeSetGroup, (IResource)this.project);
        this.changesetTable.setLayoutData(gridData);
        this.changesetTable.setEnabled(true);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ChangeSet cs = SignWizardPage.this.changesetTable.getSelection();
                SignWizardPage.this.messageTextField.setText(Messages.getString("SignWizardPage.messageTextField.text").concat(cs.toString()));
                if (SignWizardPage.this.gotGPGkeys) {
                    SignWizardPage.this.setPageComplete(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.changesetTable.addSelectionListener(listener);
        Group userGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("SignWizardPage.userGroup.title"));
        SWTWidgetHelper.createLabel((Composite)userGroup, Messages.getString("SignWizardPage.userLabel.text"));
        this.userTextField = SWTWidgetHelper.createTextField((Composite)userGroup);
        this.userTextField.setText(MercurialUtilities.getHGUsername());
        SWTWidgetHelper.createLabel((Composite)userGroup, Messages.getString("SignWizardPage.keyLabel.text"));
        this.keyCombo = SWTWidgetHelper.createCombo((Composite)userGroup);
        SWTWidgetHelper.createLabel((Composite)userGroup, Messages.getString("SignWizardPage.passphraseLabel.text"));
        this.passTextField = SWTWidgetHelper.createTextField((Composite)userGroup);
        this.passTextField.setText(Messages.getString("SignWizardPage.passTextField.text"));
        this.passTextField.setEnabled(false);
        Group optionGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("SignWizardPage.optionGroup.title"));
        this.localCheckBox = SWTWidgetHelper.createCheckBox((Composite)optionGroup, Messages.getString("SignWizardPage.localCheckBox.text"));
        this.forceCheckBox = SWTWidgetHelper.createCheckBox((Composite)optionGroup, Messages.getString("SignWizardPage.forceCheckBox.text"));
        this.noCommitCheckBox = SWTWidgetHelper.createCheckBox((Composite)optionGroup, Messages.getString("SignWizardPage.noCommitCheckBox.text"));
        SWTWidgetHelper.createLabel((Composite)optionGroup, Messages.getString("SignWizardPage.commitLabel.text"));
        this.messageTextField = SWTWidgetHelper.createTextField((Composite)optionGroup);
        this.messageTextField.setText(Messages.getString("SignWizardPage.messageTextField.defaultText"));
        this.populateKeyCombo(this.keyCombo);
        this.setControl((Control)composite);
    }

    private void populateKeyCombo(Combo combo) {
        try {
            String keys = HgSignClient.getPrivateKeyList();
            if (keys.indexOf("\n") == -1) {
                combo.add(keys);
            } else {
                String[] items;
                String[] stringArray = items = keys.split("\n\n");
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (string.trim().startsWith("sec")) {
                        combo.add(string.substring(6));
                    }
                    ++n2;
                }
            }
            this.gotGPGkeys = true;
        }
        catch (HgException e) {
            this.gotGPGkeys = false;
            combo.add(Messages.getString("SignWizardPage.errorLoadingGpgKeys"));
            this.setPageComplete(false);
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
        }
        combo.setText(combo.getItem(0));
    }

    public boolean finish(IProgressMonitor monitor) {
        ChangeSet cs = this.changesetTable.getSelection();
        String key = this.keyCombo.getText();
        key = key.substring(key.indexOf("/") + 1, key.indexOf(" "));
        String msg = this.messageTextField.getText();
        String user = this.userTextField.getText();
        String pass = this.passTextField.getText();
        boolean local = this.localCheckBox.getSelection();
        boolean force = this.forceCheckBox.getSelection();
        boolean noCommit = this.noCommitCheckBox.getSelection();
        try {
            HgSignClient.sign(this.project.getLocation().toFile(), cs, key, msg, user, local, force, noCommit, pass);
        }
        catch (HgException e) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString("SignWizardPage.errorSigning"), (String)e.getMessage());
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
            return false;
        }
        return true;
    }
}

