/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgServeClient;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ServeWizardPage
extends HgWizardPage {
    private final IResource hgroot;
    private Text nameTextField;
    private Text prefixTextField;
    private Button defaultCheckBox;
    private Text portTextField;
    private Button ipv6CheckBox;
    private Button stdioCheckBox;
    private Text webdirConfTextField;

    public ServeWizardPage(String pageName, String title, ImageDescriptor image, IResource hgRoot) {
        super(pageName, title, image);
        this.hgroot = hgRoot;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTWidgetHelper.createComposite(parent, 3);
        Group defaultsGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("ServeWizardPage.defaultsGroup.title"));
        final Group settingsGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("ServeWizardPage.settingsGroup.title"));
        settingsGroup.setEnabled(false);
        this.defaultCheckBox = SWTWidgetHelper.createCheckBox((Composite)defaultsGroup, Messages.getString("ServeWizardPage.defaultCheckBox.title"));
        this.defaultCheckBox.setSelection(true);
        final Label portLabel = SWTWidgetHelper.createLabel((Composite)settingsGroup, Messages.getString("ServeWizardPage.portLabel.title"));
        portLabel.setEnabled(false);
        this.portTextField = SWTWidgetHelper.createTextField((Composite)settingsGroup);
        this.portTextField.setEnabled(false);
        this.portTextField.setText(Messages.getString("ServeWizardPage.portTextField.defaultValue"));
        final Label nameLabel = SWTWidgetHelper.createLabel((Composite)settingsGroup, Messages.getString("ServeWizardPage.nameLabel.title"));
        nameLabel.setEnabled(false);
        this.nameTextField = SWTWidgetHelper.createTextField((Composite)settingsGroup);
        this.nameTextField.setEnabled(false);
        final Label prefixLabel = SWTWidgetHelper.createLabel((Composite)settingsGroup, Messages.getString("ServeWizardPage.prefixLabel.title"));
        prefixLabel.setEnabled(false);
        this.prefixTextField = SWTWidgetHelper.createTextField((Composite)settingsGroup);
        this.prefixTextField.setEnabled(false);
        final Label webdirLabel = SWTWidgetHelper.createLabel((Composite)settingsGroup, Messages.getString("ServeWizardPage.webdirLabel.title"));
        webdirLabel.setEnabled(false);
        this.webdirConfTextField = SWTWidgetHelper.createTextField((Composite)settingsGroup);
        this.webdirConfTextField.setEnabled(false);
        this.stdioCheckBox = SWTWidgetHelper.createCheckBox((Composite)settingsGroup, Messages.getString("ServeWizardPage.stdioCheckBox.title"));
        this.stdioCheckBox.setEnabled(false);
        this.ipv6CheckBox = SWTWidgetHelper.createCheckBox((Composite)settingsGroup, Messages.getString("ServeWizardPage.ipv6CheckBox.title"));
        this.ipv6CheckBox.setEnabled(false);
        SelectionListener defaultCheckBoxListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                settingsGroup.setEnabled(!ServeWizardPage.this.defaultCheckBox.getSelection());
                portLabel.setEnabled(!ServeWizardPage.this.defaultCheckBox.getSelection());
                ServeWizardPage.this.portTextField.setEnabled(!ServeWizardPage.this.defaultCheckBox.getSelection());
                nameLabel.setEnabled(!ServeWizardPage.this.defaultCheckBox.getSelection());
                ServeWizardPage.this.nameTextField.setEnabled(!ServeWizardPage.this.defaultCheckBox.getSelection());
                prefixLabel.setEnabled(!ServeWizardPage.this.defaultCheckBox.getSelection());
                ServeWizardPage.this.prefixTextField.setEnabled(!ServeWizardPage.this.defaultCheckBox.getSelection());
                webdirLabel.setEnabled(!ServeWizardPage.this.defaultCheckBox.getSelection());
                ServeWizardPage.this.webdirConfTextField.setEnabled(!ServeWizardPage.this.defaultCheckBox.getSelection());
                ServeWizardPage.this.stdioCheckBox.setEnabled(!ServeWizardPage.this.defaultCheckBox.getSelection());
                ServeWizardPage.this.ipv6CheckBox.setEnabled(!ServeWizardPage.this.defaultCheckBox.getSelection());
            }
        };
        this.defaultCheckBox.addSelectionListener(defaultCheckBoxListener);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public boolean finish(IProgressMonitor monitor) {
        super.finish(monitor);
        try {
            new HgServeClient().serve(this.hgroot, Integer.parseInt(this.portTextField.getText()), this.prefixTextField.getText(), this.nameTextField.getText(), this.webdirConfTextField.getText(), this.stdioCheckBox.getSelection(), this.ipv6CheckBox.getSelection());
        }
        catch (NumberFormatException e) {
            MercurialEclipsePlugin.logError(e);
            MercurialEclipsePlugin.showError(e);
        }
        return true;
    }
}

