/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.wizards.HgWizard;
import com.vectrace.MercurialEclipse.wizards.IncomingPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import com.vectrace.MercurialEclipse.wizards.PullOperation;
import com.vectrace.MercurialEclipse.wizards.PullPage;
import java.io.File;
import java.util.SortedSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;

public class PullRepoWizard
extends HgWizard {
    private boolean doUpdate;
    private PullPage pullPage;
    private IncomingPage incomingPage;
    private final IProject resource;
    private HgRepositoryLocation repo;

    public PullRepoWizard(IProject resource) {
        super(Messages.getString("PullRepoWizard.title"));
        this.resource = resource;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.pullPage = new PullPage(Messages.getString("PullRepoWizard.pullPage.name"), Messages.getString("PullRepoWizard.pullPage.title"), Messages.getString("PullRepoWizard.pullPage.description"), (IResource)this.resource.getProject(), null);
        this.initPage(this.pullPage.getDescription(), this.pullPage);
        this.addPage((IWizardPage)this.pullPage);
        this.incomingPage = new IncomingPage(Messages.getString("PullRepoWizard.incomingPage.name"));
        this.initPage(this.incomingPage.getDescription(), this.incomingPage);
        this.addPage((IWizardPage)this.incomingPage);
    }

    public boolean performFinish() {
        if (this.resource.getProject().getLocation() == null) {
            return false;
        }
        this.pullPage.finish((IProgressMonitor)new NullProgressMonitor());
        this.incomingPage.finish((IProgressMonitor)new NullProgressMonitor());
        this.repo = this.getLocation();
        this.doUpdate = this.pullPage.getUpdateCheckBox().getSelection();
        boolean force = this.pullPage.getForceCheckBox().getSelection();
        ChangeSet cs = null;
        if (this.incomingPage.getRevisionCheckBox().getSelection()) {
            cs = this.incomingPage.getRevision();
        }
        boolean timeout = this.pullPage.getTimeoutCheckBox().getSelection();
        boolean merge = this.pullPage.getMergeCheckBox().getSelection();
        boolean rebase = false;
        Button rebase_button = this.pullPage.getRebaseCheckBox();
        if (rebase_button != null) {
            rebase = rebase_button.getSelection();
        }
        boolean showCommitDialog = this.pullPage.getCommitDialogCheckBox().getSelection();
        boolean svn = false;
        if (this.pullPage.isShowSvn()) {
            svn = this.pullPage.getSvnCheckBox().getSelection();
        }
        boolean forest = false;
        File snapFile = null;
        if (this.pullPage.isShowForest()) {
            forest = this.pullPage.getForestCheckBox().getSelection();
            String snapFileText = this.pullPage.getSnapFileCombo().getText();
            if (snapFileText.length() > 0) {
                snapFile = new File(snapFileText);
            }
        }
        File bundleFile = null;
        SortedSet<ChangeSet> changesets = this.incomingPage.getChangesets();
        if (changesets != null && changesets.size() > 0) {
            bundleFile = changesets.first().getBundleFile();
        }
        PullOperation pullOperation = new PullOperation((IRunnableContext)this.getContainer(), this.doUpdate, this.resource, force, this.repo, cs, timeout, merge, showCommitDialog, bundleFile, forest, snapFile, rebase, svn);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)pullOperation);
            String output = pullOperation.getOutput();
            if (output.length() != 0) {
                HgClients.getConsole().printMessage(output, null);
            }
        }
        catch (Exception e) {
            Throwable error = e.getCause() == null ? e : e.getCause();
            MercurialEclipsePlugin.logError(error);
            MercurialEclipsePlugin.showError(error);
            return false;
        }
        return true;
    }

    private HgRepositoryLocation getLocation() {
        try {
            return MercurialEclipsePlugin.getRepoManager().fromProperties(this.pullPage.getProperties());
        }
        catch (Exception e) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString("PullRepoWizard.malformedURL"), (String)e.getMessage());
            MercurialEclipsePlugin.logInfo(e.getMessage(), e);
            return null;
        }
    }
}

