/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgStatusClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.IncomingPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import com.vectrace.MercurialEclipse.wizards.PushPullPage;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class PullPage
extends PushPullPage {
    private Button updateCheckBox;
    private Button mergeCheckBox;
    private Button commitDialogCheckBox;
    private Button rebaseCheckBox;

    public Button getRebaseCheckBox() {
        return this.rebaseCheckBox;
    }

    public Button getCommitDialogCheckBox() {
        return this.commitDialogCheckBox;
    }

    public PullPage(String pageName, String title, String description, IResource resource, ImageDescriptor titleImage) {
        super(resource, pageName, title, titleImage);
        this.setDescription(description);
        this.setShowCredentials(true);
        this.setShowBundleButton(true);
        this.setShowRevisionTable(false);
    }

    public boolean canFlipToNextPage() {
        try {
            if (this.getUrlCombo().getText() != null && this.getUrlCombo().getText() != null) {
                IncomingPage incomingPage = (IncomingPage)this.getNextPage();
                incomingPage.setProject(this.resource.getProject());
                HgRepositoryLocation loc = MercurialEclipsePlugin.getRepoManager().getRepoLocation(this.getUrlCombo().getText(), this.getUserCombo().getText(), this.getPasswordText().getText());
                incomingPage.setLocation(loc);
                incomingPage.setSvn(this.getSvnCheckBox() != null && this.getSvnCheckBox().getSelection());
                this.setErrorMessage(null);
                return this.isPageComplete() && this.getWizard().getNextPage((IWizardPage)this) != null;
            }
        }
        catch (URISyntaxException e) {
            this.setErrorMessage(e.getLocalizedMessage());
        }
        return false;
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && HgRepositoryLocation.validateLocation(this.getUrlCombo().getText());
    }

    protected boolean isPageComplete(String url) {
        return HgRepositoryLocation.validateLocation(url);
    }

    protected boolean validateAndSetComplete(String url) {
        boolean validLocation = this.isPageComplete(url);
        this.setPageComplete(validLocation);
        return validLocation;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        Group pullGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("PullPage.pullGroup.label"));
        this.updateCheckBox = SWTWidgetHelper.createCheckBox((Composite)pullGroup, Messages.getString("PullPage.toggleUpdate.text"));
        this.updateCheckBox.setSelection(true);
        try {
            if (MercurialUtilities.isCommandAvailable("rebase", ResourceProperties.REBASE_AVAILABLE, "hgext.rebase=")) {
                this.rebaseCheckBox = SWTWidgetHelper.createCheckBox((Composite)pullGroup, Messages.getString("PullPage.option.rebase"));
                SelectionListener rebaseCheckBoxListener = new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }

                    public void widgetSelected(SelectionEvent e) {
                        if (PullPage.this.rebaseCheckBox.getSelection()) {
                            PullPage.this.updateCheckBox.setSelection(!PullPage.this.rebaseCheckBox.getSelection());
                        }
                    }
                };
                SelectionListener updateCheckBoxListener = new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }

                    public void widgetSelected(SelectionEvent e) {
                        if (PullPage.this.updateCheckBox.getSelection()) {
                            PullPage.this.rebaseCheckBox.setSelection(!PullPage.this.updateCheckBox.getSelection());
                        }
                    }
                };
                this.rebaseCheckBox.addSelectionListener(rebaseCheckBoxListener);
                this.updateCheckBox.addSelectionListener(updateCheckBoxListener);
            }
        }
        catch (HgException e2) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e2));
        }
        this.forceCheckBox.setParent((Composite)pullGroup);
        pullGroup.moveAbove((Control)this.optionGroup);
        Group mergeGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("PullPage.option.merge"));
        this.mergeCheckBox = SWTWidgetHelper.createCheckBox((Composite)mergeGroup, Messages.getString("PullPage.option.commitAfterMerge"));
        this.commitDialogCheckBox = SWTWidgetHelper.createCheckBox((Composite)mergeGroup, Messages.getString("PullPage.option.editCommitMessage"));
        this.commitDialogCheckBox.setSelection(true);
        this.commitDialogCheckBox.setEnabled(false);
        mergeGroup.moveBelow((Control)pullGroup);
        SelectionListener mergeCheckBoxListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                block5: {
                    PullPage.this.commitDialogCheckBox.setEnabled(PullPage.this.mergeCheckBox.getSelection());
                    if (PullPage.this.mergeCheckBox.getSelection()) {
                        try {
                            String status = HgStatusClient.getStatus((IContainer)PullPage.this.resource.getProject());
                            if (status.length() > 0 && status.indexOf("M ") >= 0) {
                                PullPage.this.setErrorMessage(Messages.getString("PullPage.error.modifiedResources"));
                                PullPage.this.setPageComplete(false);
                                break block5;
                            }
                            PullPage.this.setErrorMessage(null);
                            PullPage.this.setPageComplete(true);
                        }
                        catch (HgException hgException) {
                            PullPage.this.setErrorMessage(Messages.getString("PullPage.error.noStatus"));
                            PullPage.this.mergeCheckBox.setSelection(false);
                            PullPage.this.mergeCheckBox.setEnabled(false);
                            PullPage.this.setPageComplete(true);
                        }
                    } else {
                        PullPage.this.setErrorMessage(null);
                        PullPage.this.setPageComplete(true);
                    }
                }
            }
        };
        this.mergeCheckBox.addSelectionListener(mergeCheckBoxListener);
        this.setPageComplete(true);
        this.setControl((Control)composite);
    }

    public boolean finish(IProgressMonitor monitor) {
        return super.finish(monitor);
    }

    protected String getForceCheckBoxLabel() {
        return Messages.getString("PullPage.forceCheckBox.title");
    }

    protected String getRevGroupLabel() {
        return Messages.getString("PullPage.revGroup.title");
    }

    protected String getRevCheckBoxLabel() {
        return Messages.getString("PullPage.revCheckBox.title");
    }

    protected String getTimeoutCheckBoxLabel() {
        return Messages.getString("PullPage.timeoutCheckBox.title");
    }

    public Button getUpdateCheckBox() {
        return this.updateCheckBox;
    }

    public void setUpdateCheckBox(Button updateCheckBox) {
        this.updateCheckBox = updateCheckBox;
    }

    public Button getMergeCheckBox() {
        return this.mergeCheckBox;
    }
}

