/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeUiJob;
import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.commands.HgLogClient;
import com.vectrace.MercurialEclipse.commands.HgPushPullClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgSvnClient;
import com.vectrace.MercurialEclipse.commands.extensions.forest.HgFpushPullClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.menu.MergeHandler;
import com.vectrace.MercurialEclipse.menu.UpdateHandler;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableContext;

class PullOperation
extends HgOperation {
    private final boolean doUpdate;
    private final IProject resource;
    private final HgRepositoryLocation repo;
    private final boolean force;
    private final ChangeSet pullRevision;
    private final boolean timeout;
    private final boolean merge;
    private String output = "";
    private final boolean showCommitDialog;
    private final File bundleFile;
    private final boolean forest;
    private final File snapFile;
    private final boolean rebase;
    private final boolean svn;

    public PullOperation(IRunnableContext context, boolean doUpdate, IProject resource, boolean force, HgRepositoryLocation repo, ChangeSet pullRevision, boolean timeout, boolean merge, boolean showCommitDialog, File bundleFile, boolean forest, File snapFile, boolean rebase, boolean svn) {
        super(context);
        this.doUpdate = doUpdate;
        this.resource = resource;
        this.force = force;
        this.repo = repo;
        this.pullRevision = pullRevision;
        this.timeout = timeout;
        this.merge = merge;
        this.showCommitDialog = showCommitDialog;
        this.bundleFile = bundleFile;
        this.forest = forest;
        this.snapFile = snapFile;
        this.rebase = rebase;
        this.svn = svn;
    }

    protected String getActionDescription() {
        return Messages.getString("PullRepoWizard.pullOperation.description");
    }

    private String performMerge(IProgressMonitor monitor) throws HgException, InterruptedException {
        String r = Messages.getString("PullRepoWizard.pullOperation.mergeHeader");
        monitor.subTask(Messages.getString("PullRepoWizard.pullOperation.merging"));
        if (HgLogClient.getHeads(this.resource.getProject()).length > 1) {
            SafeUiJob job = new SafeUiJob(Messages.getString("PullRepoWizard.pullOperation.mergeJob.description")){

                protected IStatus runSafe(IProgressMonitor m) {
                    try {
                        String res = MergeHandler.merge(PullOperation.this.resource, PullOperation.this.getShell(), m, true, PullOperation.this.showCommitDialog);
                        return new Status(0, "com.vectrace.MercurialEclipse", res);
                    }
                    catch (CoreException e) {
                        MercurialEclipsePlugin.logError(e);
                        return e.getStatus();
                    }
                }
            };
            job.schedule();
            job.join();
            IStatus jobResult = job.getResult();
            if (jobResult.getSeverity() == 0) {
                r = String.valueOf(r) + jobResult.getMessage();
            } else {
                throw new HgException(jobResult);
            }
        }
        monitor.worked(1);
        return r;
    }

    private String performPull(HgRepositoryLocation repository, IProgressMonitor monitor) throws CoreException {
        monitor.worked(1);
        monitor.subTask(Messages.getString("PullRepoWizard.pullOperation.incoming"));
        String r = Messages.getString("PullRepoWizard.pullOperation.pull.header");
        boolean updateSeparately = false;
        if (this.svn) {
            r = String.valueOf(r) + HgSvnClient.pull((IResource)this.resource);
            if (this.rebase) {
                r = String.valueOf(r) + HgSvnClient.rebase((IResource)this.resource);
            }
        } else if (this.bundleFile == null) {
            if (this.forest) {
                File forestRoot = MercurialTeamProvider.getHgRoot((IResource)this.resource).getParentFile();
                r = String.valueOf(r) + HgFpushPullClient.fpull(forestRoot, this.repo, this.doUpdate, this.timeout, this.pullRevision, true, this.snapFile, false);
            } else {
                if (this.doUpdate) {
                    updateSeparately = true;
                }
                r = String.valueOf(r) + HgPushPullClient.pull(this.resource, this.pullRevision, this.repo, false, this.rebase, this.force, this.timeout);
            }
        } else {
            if (this.doUpdate) {
                updateSeparately = true;
            }
            r = String.valueOf(r) + HgPushPullClient.pull(this.resource, this.pullRevision, this.getBundlePath(), false, this.rebase, this.force, this.timeout);
        }
        monitor.worked(1);
        this.saveRepo(monitor);
        if (updateSeparately) {
            this.runUpdate();
        }
        return r;
    }

    private String getBundlePath() throws HgException {
        String canonicalPath = null;
        try {
            canonicalPath = this.bundleFile.getCanonicalPath();
        }
        catch (IOException e) {
            String message = "Failed to get canonical bundle path for: " + this.bundleFile;
            MercurialEclipsePlugin.logError(message, e);
            throw new HgException(message, e);
        }
        return canonicalPath;
    }

    private void runUpdate() {
        new Job("Hg update after pull"){

            public IStatus run(IProgressMonitor monitor1) {
                try {
                    new UpdateHandler().run((IResource)PullOperation.this.resource);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    if (e instanceof HgException && (PullOperation.this.merge || PullOperation.this.rebase) && e.getMessage().contains("crosses branches")) {
                        return Status.OK_STATUS;
                    }
                    MercurialEclipsePlugin.logError(e);
                    MercurialEclipsePlugin.showError(e);
                    return Status.CANCEL_STATUS;
                }
            }
        }.schedule();
    }

    private boolean saveRepo(IProgressMonitor monitor) {
        monitor.subTask(String.valueOf(Messages.getString("PullRepoWizard.pullOperation.addRepo")) + this.repo);
        try {
            MercurialEclipsePlugin.getRepoManager().addRepoLocation(this.resource.getProject(), this.repo);
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError(Messages.getString("PullRepoWizard.addingRepositoryFailed"), (Throwable)((Object)e));
        }
        monitor.worked(1);
        return true;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(Messages.getString("PullRepoWizard.pullOperation.pulling"), 6);
            this.output = String.valueOf(this.output) + this.performPull(this.repo, monitor);
            if (this.merge) {
                this.output = String.valueOf(this.output) + this.performMerge(monitor);
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e, e.getMessage());
        }
        monitor.done();
    }

    public String getOutput() {
        return this.output;
    }
}

