/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgPatchClient;
import com.vectrace.MercurialEclipse.ui.LocationChooser;
import com.vectrace.MercurialEclipse.utils.ClipboardUtils;
import com.vectrace.MercurialEclipse.wizards.HgWizard;
import com.vectrace.MercurialEclipse.wizards.ImportOptionsPage;
import com.vectrace.MercurialEclipse.wizards.ImportPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.team.ui.TeamOperation;

public class ImportWizard
extends HgWizard {
    private final ImportPage sourcePage;
    private final ImportOptionsPage optionsPage;
    private LocationChooser.Location location;
    private final IProject project;
    private String result;
    private ArrayList<String> options;

    public ImportWizard(IResource selection) {
        super(Messages.getString("ImportWizard.WizardTitle"));
        this.setNeedsProgressMonitor(true);
        this.project = selection.getProject();
        this.sourcePage = new ImportPage(this.project);
        this.addPage((IWizardPage)this.sourcePage);
        this.initPage(Messages.getString("ImportWizard.pageDescription"), this.sourcePage);
        this.optionsPage = new ImportOptionsPage();
        this.addPage((IWizardPage)this.optionsPage);
        this.initPage(Messages.getString("ImportWizard.optionsPageDescription"), this.optionsPage);
    }

    public boolean performFinish() {
        this.sourcePage.finish(null);
        try {
            this.location = this.sourcePage.getLocation();
            this.options = this.optionsPage.getOptions();
            this.result = null;
            ImportOperation operation = new ImportOperation((IRunnableContext)this.getContainer());
            this.getContainer().run(true, false, (IRunnableWithProgress)operation);
            if (this.result != null) {
                this.optionsPage.setErrorMessage(this.result);
                return false;
            }
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(this.getWindowTitle(), e);
            MercurialEclipsePlugin.showError(e.getCause());
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void performOperation() throws Exception {
        if (this.location.getLocationType() == LocationChooser.LocationType.Clipboard) {
            file = null;
            try {
                file = ClipboardUtils.clipboardToTempFile("mercurial_", ".patch");
                if (file == null) ** GOTO lbl15
                HgPatchClient.importPatch(this.project, file, this.options);
            }
            finally {
                if (file != null && file.exists() && !(deleted = file.delete())) {
                    MercurialEclipsePlugin.logError("Failed to delete clipboard content file: " + file, null);
                }
            }
        } else {
            HgPatchClient.importPatch(this.project, this.location.getFile(), this.options);
        }
lbl15:
        // 3 sources

        this.project.refreshLocal(0, null);
    }

    class ImportOperation
    extends TeamOperation {
        public ImportOperation(IRunnableContext context) {
            super(context);
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.getString("ExportWizard.pageTitle"), 1);
            try {
                try {
                    ImportWizard.this.performOperation();
                }
                catch (Exception e) {
                    ImportWizard.this.result = e.getLocalizedMessage();
                    MercurialEclipsePlugin.logError(String.valueOf(Messages.getString("ExportWizard.pageTitle")) + " failed:", e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

