/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportOptionsPage
extends HgWizardPage
implements Listener {
    private Button chkForce;
    private Button chkStrip;
    private Button chkBase;
    private Button chkNoCommit;
    private Button chkExact;
    private Text txtUser;
    private Text txtDate;
    private SourceViewer txtComments;
    private Button chkUser;
    private Button chkDate;
    private Button chkComments;
    private Text txtBase;
    private Text txtStrip;

    public ImportOptionsPage() {
        super(Messages.getString("ImportWizard.optionsPageName"), Messages.getString("ImportWizard.optionsPageTitle"), null);
    }

    protected boolean validatePage() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTWidgetHelper.createComposite(parent, 2);
        this.chkForce = SWTWidgetHelper.createCheckBox(composite, Messages.getString("ImportOptionsPage.force"));
        this.chkStrip = ImportOptionsPage.createLabelCheckBox(composite, Messages.getString("ImportOptionsPage.strip"));
        this.chkStrip.addListener(13, (Listener)this);
        this.txtStrip = SWTWidgetHelper.createTextField(composite);
        this.chkBase = ImportOptionsPage.createLabelCheckBox(composite, Messages.getString("ImportOptionsPage.base"));
        this.chkBase.addListener(13, (Listener)this);
        this.txtBase = SWTWidgetHelper.createTextField(composite);
        this.chkNoCommit = SWTWidgetHelper.createCheckBox(composite, Messages.getString("ImportOptionsPage.noCommit"));
        this.chkNoCommit.setSelection(true);
        this.chkExact = SWTWidgetHelper.createCheckBox(composite, Messages.getString("ImportOptionsPage.exact"));
        this.chkUser = ImportOptionsPage.createLabelCheckBox(composite, Messages.getString("ImportOptionsPage.user"));
        this.chkUser.addListener(13, (Listener)this);
        this.txtUser = SWTWidgetHelper.createTextField(composite);
        this.chkDate = ImportOptionsPage.createLabelCheckBox(composite, Messages.getString("ImportOptionsPage.date"));
        this.chkDate.addListener(13, (Listener)this);
        this.txtDate = SWTWidgetHelper.createTextField(composite);
        String date = DateFormat.getDateTimeInstance().format(new Date());
        this.txtDate.setText(date);
        this.chkComments = ImportOptionsPage.createLabelCheckBox(composite, Messages.getString("ImportOptionsPage.comments"));
        this.chkComments.addListener(13, (Listener)this);
        this.txtComments = SWTWidgetHelper.createTextArea(composite);
        this.setControl((Control)composite);
        this.validate();
    }

    public void handleEvent(Event event) {
        this.validate();
    }

    private void validate() {
        this.txtUser.setEnabled(this.chkUser.getSelection());
        this.txtDate.setEnabled(this.chkDate.getSelection());
        this.txtComments.getControl().setEnabled(this.chkComments.getSelection());
        this.txtBase.setEnabled(this.chkBase.getSelection());
        this.txtStrip.setEnabled(this.chkStrip.getSelection());
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    @Override
    public boolean finish(IProgressMonitor monitor) {
        return super.finish(monitor);
    }

    ArrayList<String> getOptions() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.chkStrip.getSelection()) {
            list.add("-p " + this.txtStrip.getText());
        }
        if (this.chkForce.getSelection()) {
            list.add("-f");
        }
        if (this.chkBase.getSelection()) {
            list.add("-b " + this.txtBase.getText());
        }
        if (this.chkNoCommit.getSelection()) {
            list.add("--no-commit");
        }
        if (this.chkExact.getSelection()) {
            list.add("--exact");
        }
        if (this.chkUser.getSelection()) {
            list.add("-u " + this.txtUser.getText());
        }
        if (this.chkDate.getSelection()) {
            list.add("-d \"" + this.txtDate.getText() + '\"');
        }
        if (this.chkComments.getSelection()) {
            list.add("-m " + this.txtComments.getDocument().get());
        }
        return list;
    }

    public static Button createLabelCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        return button;
    }
}

