/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.views;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.extensions.mq.HgQFoldClient;
import com.vectrace.MercurialEclipse.commands.extensions.mq.HgQPopClient;
import com.vectrace.MercurialEclipse.commands.extensions.mq.HgQPushClient;
import com.vectrace.MercurialEclipse.commands.extensions.mq.HgQSeriesClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.menu.QDeleteHandler;
import com.vectrace.MercurialEclipse.menu.QImportHandler;
import com.vectrace.MercurialEclipse.menu.QNewHandler;
import com.vectrace.MercurialEclipse.menu.QRefreshHandler;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.model.Patch;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.ui.PatchTable;
import com.vectrace.MercurialEclipse.views.Messages;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.core.Team;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class PatchQueueView
extends ViewPart
implements ISelectionListener {
    private IResource resource;
    private PatchTable table;
    private Label statusLabel;
    private Action qNewAction;
    private Action qRefreshAction;
    private Action qPushAction;
    private Action qPushAllAction;
    private Action qPopAction;
    private Action qPopAllAction;
    private Action qDeleteAction;
    private Action qFoldAction;
    private Action qImportAction;
    private HgRoot currentHgRoot;
    public static final String ID = PatchQueueView.class.getName();

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.statusLabel = new Label(parent, 0);
        this.statusLabel.setLayoutData((Object)new GridData(768));
        this.table = new PatchTable(parent);
        this.createActions();
        this.createToolBar();
        this.createMenus();
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    private void createToolBar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.qImportAction);
        mgr.add((IAction)this.qNewAction);
        mgr.add((IAction)this.qRefreshAction);
        mgr.add((IAction)this.qPushAction);
        mgr.add((IAction)this.qPopAction);
        mgr.add((IAction)this.qPushAllAction);
        mgr.add((IAction)this.qPopAllAction);
        mgr.add((IAction)this.qFoldAction);
        mgr.add((IAction)this.qDeleteAction);
    }

    private void createActions() {
        this.qImportAction = new Action("qimport"){

            public void run() {
                try {
                    QImportHandler.openWizard(PatchQueueView.this.resource, PatchQueueView.this.getSite().getShell());
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                }
            }
        };
        this.qImportAction.setEnabled(true);
        this.qNewAction = new Action("qnew"){

            public void run() {
                try {
                    QNewHandler.openWizard(PatchQueueView.this.resource, PatchQueueView.this.getSite().getShell());
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                }
            }
        };
        this.qNewAction.setEnabled(true);
        this.qRefreshAction = new Action("qrefresh"){

            public void run() {
                QRefreshHandler.openWizard(PatchQueueView.this.resource, PatchQueueView.this.getSite().getShell());
            }
        };
        this.qRefreshAction.setEnabled(true);
        this.qPushAction = new Action("qpush"){

            public void run() {
                try {
                    HgQPushClient.push(PatchQueueView.this.resource, false, PatchQueueView.this.table.getSelection().getName());
                    PatchQueueView.this.populateTable();
                    PatchQueueView.this.resource.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                    PatchQueueView.this.statusLabel.setText(e.getLocalizedMessage());
                }
            }
        };
        this.qPushAction.setEnabled(true);
        this.qPopAction = new Action("qpop"){

            public void run() {
                try {
                    HgQPopClient.pop(PatchQueueView.this.resource, false, PatchQueueView.this.table.getSelection().getName());
                    PatchQueueView.this.populateTable();
                    PatchQueueView.this.resource.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                    PatchQueueView.this.statusLabel.setText(e.getLocalizedMessage());
                }
            }
        };
        this.qPopAction.setEnabled(true);
        this.qPushAllAction = new Action("qpush all"){

            public void run() {
                try {
                    HgQPushClient.pushAll(PatchQueueView.this.resource, false);
                    PatchQueueView.this.populateTable();
                    PatchQueueView.this.resource.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                    PatchQueueView.this.statusLabel.setText(e.getLocalizedMessage());
                }
            }
        };
        this.qPushAllAction.setEnabled(true);
        this.qPopAllAction = new Action("qpop all"){

            public void run() {
                try {
                    HgQPopClient.popAll(PatchQueueView.this.resource, false);
                    PatchQueueView.this.populateTable();
                    PatchQueueView.this.resource.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                    PatchQueueView.this.statusLabel.setText(e.getLocalizedMessage());
                }
            }
        };
        this.qPopAllAction.setEnabled(true);
        this.qFoldAction = new Action("qfold"){

            public void run() {
                try {
                    List<Patch> patches = PatchQueueView.this.table.getSelections();
                    if (patches.size() > 0) {
                        HgQFoldClient.fold(PatchQueueView.this.resource, true, null, patches);
                        PatchQueueView.this.populateTable();
                    }
                }
                catch (HgException e) {
                    MercurialEclipsePlugin.logError((Throwable)((Object)e));
                    PatchQueueView.this.statusLabel.setText(e.getLocalizedMessage());
                }
            }
        };
        this.qFoldAction.setEnabled(true);
        this.qDeleteAction = new Action("qdel"){

            public void run() {
                QDeleteHandler.openWizard(PatchQueueView.this.resource, PatchQueueView.this.getSite().getShell());
                PatchQueueView.this.populateTable();
                try {
                    PatchQueueView.this.resource.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    MercurialEclipsePlugin.logError(e);
                    PatchQueueView.this.statusLabel.setText(e.getLocalizedMessage());
                }
            }
        };
        this.qDeleteAction.setEnabled(true);
    }

    private void createMenus() {
        IMenuManager menuMgr = this.getViewSite().getActionBars().getMenuManager();
        menuMgr.add((IAction)this.qImportAction);
        menuMgr.add((IAction)this.qNewAction);
        menuMgr.add((IAction)this.qRefreshAction);
        menuMgr.add((IAction)this.qPushAction);
        menuMgr.add((IAction)this.qPopAction);
        menuMgr.add((IAction)this.qPushAllAction);
        menuMgr.add((IAction)this.qPopAllAction);
        menuMgr.add((IAction)this.qFoldAction);
        menuMgr.add((IAction)this.qDeleteAction);
    }

    public void setFocus() {
        this.populateTable();
    }

    public void populateTable() {
        if (this.resource != null && this.resource.isAccessible() && !this.resource.isDerived() && !this.resource.isLinked() && !Team.isIgnoredHint((IResource)this.resource)) {
            try {
                List<Patch> patches = HgQSeriesClient.getPatchesInSeries(this.resource);
                this.table.setPatches(patches.toArray(new Patch[patches.size()]));
            }
            catch (HgException e) {
                this.statusLabel.setText(e.getLocalizedMessage());
                MercurialEclipsePlugin.logError((Throwable)((Object)e));
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        try {
            IEditorInput input;
            IFile file;
            HgRoot newRoot;
            IStructuredSelection structured;
            if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).getFirstElement() instanceof IAdaptable) {
                IResource newResource = (IResource)((IAdaptable)structured.getFirstElement()).getAdapter(IResource.class);
                if (this.resource != null && this.resource.isAccessible() && MercurialUtilities.hgIsTeamProviderFor(this.resource, false) && newResource != null && newResource.equals((Object)this.resource)) {
                    return;
                }
                if (newResource != null && newResource.isAccessible() && MercurialUtilities.hgIsTeamProviderFor(newResource, false) && !(newRoot = AbstractClient.getHgRoot(newResource)).equals(this.currentHgRoot)) {
                    this.currentHgRoot = newRoot;
                    this.resource = newResource;
                    this.populateTable();
                    this.statusLabel.setText(String.valueOf(Messages.getString("PatchQueueView.repository")) + this.currentHgRoot);
                }
            }
            if (part instanceof IEditorPart && (file = (IFile)(input = ((IEditorPart)part).getEditorInput()).getAdapter(IFile.class)) != null && file.isAccessible() && MercurialUtilities.hgIsTeamProviderFor((IResource)file, false) && !(newRoot = AbstractClient.getHgRoot((IResource)file)).equals(this.currentHgRoot)) {
                this.currentHgRoot = newRoot;
                this.resource = file;
                this.statusLabel.setText(String.valueOf(Messages.getString("PatchQueueView.repository")) + this.currentHgRoot);
            }
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
            this.statusLabel.setText(e.getMessage());
        }
    }

    public static PatchQueueView getView() {
        PatchQueueView view = (PatchQueueView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(ID);
        if (view == null) {
            try {
                view = (PatchQueueView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID);
            }
            catch (PartInitException e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
        return view;
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }
}

