/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.utils;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class ClipboardUtils {
    public static void copyToClipboard(final String result) {
        if (result == null) {
            return;
        }
        if (MercurialEclipsePlugin.getStandardDisplay().getThread() == Thread.currentThread()) {
            Clipboard cb = new Clipboard(MercurialEclipsePlugin.getStandardDisplay());
            cb.setContents(new Object[]{result}, new Transfer[]{TextTransfer.getInstance()});
            cb.dispose();
            return;
        }
        MercurialEclipsePlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                ClipboardUtils.copyToClipboard(result);
            }
        });
    }

    public static String getClipboardString() {
        if (MercurialEclipsePlugin.getStandardDisplay().getThread() == Thread.currentThread()) {
            Clipboard cb = new Clipboard(MercurialEclipsePlugin.getStandardDisplay());
            String result = (String)cb.getContents((Transfer)TextTransfer.getInstance());
            cb.dispose();
            return result;
        }
        final String[] r = new String[1];
        MercurialEclipsePlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                r[0] = ClipboardUtils.getClipboardString();
            }
        });
        return r[0];
    }

    public static File clipboardToTempFile(String prefix, String suffix) throws HgException {
        File file = null;
        String txt = ClipboardUtils.getClipboardString();
        if (txt == null || txt.trim().length() == 0) {
            return null;
        }
        OutputStreamWriter w = null;
        try {
            file = File.createTempFile(prefix, suffix);
            w = new FileWriter(file);
            w.write(txt);
            File file2 = file;
            return file2;
        }
        catch (IOException e) {
            boolean deleted;
            if (file != null && file.exists() && !(deleted = file.delete())) {
                MercurialEclipsePlugin.logError("Failed to delete clipboard content file: " + file, null);
            }
            throw new HgException(Messages.getString("ClipboardUtils.error.writeTempFile"), e);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e1) {
                    MercurialEclipsePlugin.logError(e1);
                }
            }
        }
    }

    public static boolean isEmpty() {
        Clipboard cb = new Clipboard(MercurialEclipsePlugin.getStandardDisplay());
        String contents = (String)cb.getContents((Transfer)TextTransfer.getInstance());
        cb.dispose();
        return contents == null || contents.trim().length() == 0;
    }
}

