/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.ui;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocationManager;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.dialogs.PropertyPage;

public class HgProjectPropertyPage
extends PropertyPage {
    private IProject project;
    private Group reposGroup;

    protected Control createContents(Composite parent) {
        this.project = (IProject)super.getElement();
        Composite comp = SWTWidgetHelper.createComposite(parent, 1);
        if (!MercurialUtilities.hgIsTeamProviderFor((IResource)this.project, false)) {
            this.setMessage("This project doesn't use MercurialEclipse as Team provider.");
            return comp;
        }
        this.reposGroup = SWTWidgetHelper.createGroup(comp, "Repository paths:", 1, 768);
        final HgRepositoryLocationManager mgr = MercurialEclipsePlugin.getRepoManager();
        Set<HgRepositoryLocation> repos = mgr.getAllProjectRepoLocations(this.project);
        for (final HgRepositoryLocation repo : repos) {
            Composite repoComposite = SWTWidgetHelper.createComposite((Composite)this.reposGroup, 3);
            SWTWidgetHelper.createLabel(repoComposite, repo.getLogicalName() == null ? "Unnamed" : repo.getLogicalName());
            Combo combo = SWTWidgetHelper.createEditableCombo(repoComposite);
            Button defaultButton = SWTWidgetHelper.createPushButton(repoComposite, "Set as default", 1);
            defaultButton.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    try {
                        mgr.setDefaultProjectRepository(HgProjectPropertyPage.this.project, repo);
                    }
                    catch (CoreException e1) {
                        MercurialEclipsePlugin.logError(e1);
                        HgProjectPropertyPage.this.setErrorMessage(e1.getLocalizedMessage());
                    }
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
            combo.add(repo.getLocation());
            combo.select(0);
        }
        return comp;
    }

    public boolean performOk() {
        Control[] composites;
        if (!MercurialUtilities.hgIsTeamProviderFor((IResource)this.project, false)) {
            return super.performOk();
        }
        IPreferenceStore store = MercurialEclipsePlugin.getDefault().getPreferenceStore();
        Control[] controlArray = composites = this.reposGroup.getChildren();
        int n = composites.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            Composite comp = (Composite)control;
            Control[] controls = comp.getChildren();
            store.putValue("repository." + controls[0].getData(), ((Combo)controls[1]).getText());
            ++n2;
        }
        return super.performOk();
    }

    protected void performApply() {
        this.performOk();
    }
}

