/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.ui;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.TableColumnSorter;
import com.vectrace.MercurialEclipse.compare.RevisionNode;
import com.vectrace.MercurialEclipse.dialogs.CommitResource;
import com.vectrace.MercurialEclipse.dialogs.CommitResourceLabelProvider;
import com.vectrace.MercurialEclipse.dialogs.CommitResourceUtil;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.team.MercurialRevisionStorage;
import com.vectrace.MercurialEclipse.ui.CommittableFilesFilter;
import com.vectrace.MercurialEclipse.ui.DiffTray;
import com.vectrace.MercurialEclipse.ui.Messages;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.ui.UntrackedFilesFilter;
import com.vectrace.MercurialEclipse.utils.CompareUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ResourceNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitFilesChooser
extends Composite {
    private final UntrackedFilesFilter untrackedFilesFilter;
    private final CommittableFilesFilter committableFilesFilter;
    private final boolean selectable;
    private Button showUntrackedFilesButton;
    private Button selectAllButton;
    private final CheckboxTableViewer viewer;
    private final boolean untracked;
    private final boolean missing;
    private final ListenerList stateListeners = new ListenerList();
    protected Control trayButton;
    protected boolean trayClosed = true;
    protected IFile selectedFile;
    private Label rightSeparator;
    private Label leftSeparator;
    private Control trayControl;
    private Sash sash;
    private DiffTray tray;

    public CheckboxTableViewer getViewer() {
        return this.viewer;
    }

    public CommitFilesChooser(Composite container, boolean selectable, List<IResource> resources, boolean showUntracked, boolean showMissing) {
        super(container, container.getStyle());
        this.selectable = selectable;
        this.untracked = showUntracked;
        this.missing = showMissing;
        this.untrackedFilesFilter = new UntrackedFilesFilter(this.missing);
        this.committableFilesFilter = new CommittableFilesFilter();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 3;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(SWTWidgetHelper.getFillGD(200));
        Table table = this.createTable();
        this.createOptionCheckbox();
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CommitResourceLabelProvider());
        this.viewer.addFilter((ViewerFilter)this.committableFilesFilter);
        if (!showUntracked) {
            this.viewer.addFilter((ViewerFilter)this.untrackedFilesFilter);
        }
        this.setResources(resources);
        this.createShowDiffButton(container);
        this.createFileSelectionListener();
        this.makeActions();
    }

    private void createFileSelectionListener() {
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel;
                CommitResource commitResource;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (commitResource = (CommitResource)(sel = (IStructuredSelection)selection).getFirstElement()) != null) {
                    IFile oldSelectedFile = CommitFilesChooser.this.selectedFile;
                    CommitFilesChooser.this.selectedFile = (IFile)commitResource.getResource();
                    if (oldSelectedFile == null || !oldSelectedFile.equals((Object)CommitFilesChooser.this.selectedFile)) {
                        CommitFilesChooser.this.trayButton.setEnabled(true);
                        if (!CommitFilesChooser.this.trayClosed) {
                            CommitFilesChooser.this.closeSash();
                            CommitFilesChooser.this.openSash();
                        }
                    }
                }
            }
        });
    }

    private void createShowDiffButton(Composite container) {
        this.trayButton = SWTWidgetHelper.createPushButton(container, Messages.getString("CommitFilesChooser.showDiffButton.text"), 1);
        this.trayButton.setEnabled(false);
        this.trayButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CommitFilesChooser.this.showDiffForSelection();
            }
        });
    }

    private void openSash() {
        DiffTray t = new DiffTray(this.getCompareEditorInput());
        final Shell shell = this.getShell();
        this.leftSeparator = new Label((Composite)shell, 514);
        this.leftSeparator.setLayoutData((Object)new GridData(1040));
        this.sash = new Sash((Composite)shell, 512);
        this.sash.setLayoutData((Object)new GridData(1040));
        this.rightSeparator = new Label((Composite)shell, 514);
        this.rightSeparator.setLayoutData((Object)new GridData(1040));
        this.trayControl = t.createContents((Composite)shell);
        Rectangle clientArea = shell.getClientArea();
        final GridData data = new GridData(1040);
        data.widthHint = this.trayControl.computeSize((int)-1, (int)clientArea.height).x;
        this.trayControl.setLayoutData((Object)data);
        int trayWidth = this.leftSeparator.computeSize((int)-1, (int)clientArea.height).x + this.sash.computeSize((int)-1, (int)clientArea.height).x + this.rightSeparator.computeSize((int)-1, (int)clientArea.height).x + data.widthHint;
        Rectangle bounds = shell.getBounds();
        shell.setBounds(bounds.x - (Window.getDefaultOrientation() == 0x4000000 ? trayWidth : 0), bounds.y, bounds.width + trayWidth, bounds.height);
        this.sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail != 1) {
                    Rectangle rect = shell.getClientArea();
                    int newWidth = rect.width - event.x - (((CommitFilesChooser)CommitFilesChooser.this).sash.getSize().x + ((CommitFilesChooser)CommitFilesChooser.this).rightSeparator.getSize().x);
                    if (newWidth != data.widthHint) {
                        data.widthHint = newWidth;
                        shell.layout();
                    }
                }
            }
        });
        this.tray = t;
    }

    private Table createTable() {
        int flags = 2816;
        flags = this.selectable ? (flags |= 0x10022) : (flags |= 0x8008);
        Table table = new Table((Composite)this, flags);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        table.setLayoutData((Object)data);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Messages.getString("Common.ColumnFile"));
        col.setWidth(400);
        col.setMoveable(true);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Messages.getString("Common.ColumnStatus"));
        col.setWidth(70);
        col.setMoveable(true);
        return table;
    }

    private void createOptionCheckbox() {
        if (!this.selectable) {
            return;
        }
        this.selectAllButton = new Button((Composite)this, 32);
        this.selectAllButton.setText(Messages.getString("Common.SelectOrUnselectAll"));
        this.selectAllButton.setLayoutData((Object)new GridData(768));
        if (!this.untracked) {
            return;
        }
        this.showUntrackedFilesButton = new Button((Composite)this, 32);
        this.showUntrackedFilesButton.setText(Messages.getString("Common.ShowUntrackedFiles"));
        this.showUntrackedFilesButton.setLayoutData((Object)new GridData(768));
    }

    protected CompareEditorInput getCompareEditorInput() {
        if (this.selectedFile == null) {
            return null;
        }
        MercurialRevisionStorage iStorage = new MercurialRevisionStorage((IResource)this.selectedFile);
        RevisionNode right = new RevisionNode(iStorage);
        ResourceNode left = new ResourceNode((IResource)this.selectedFile);
        return CompareUtils.getCompareInput(left, right, false);
    }

    private void makeActions() {
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CommitFilesChooser.this.showDiffForSelection();
            }
        });
        this.getViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CommitFilesChooser.this.fireStateChanged();
            }
        });
        if (this.selectable) {
            this.selectAllButton.setSelection(false);
        }
        if (this.selectable) {
            this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (CommitFilesChooser.this.selectAllButton.getSelection()) {
                        CommitFilesChooser.this.getViewer().setAllChecked(true);
                    } else {
                        CommitFilesChooser.this.getViewer().setAllChecked(false);
                    }
                    CommitFilesChooser.this.fireStateChanged();
                }
            });
        }
        if (this.selectable && this.untracked) {
            this.showUntrackedFilesButton.setSelection(true);
            this.showUntrackedFilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (CommitFilesChooser.this.showUntrackedFilesButton.getSelection()) {
                        CommitFilesChooser.this.getViewer().removeFilter((ViewerFilter)CommitFilesChooser.this.untrackedFilesFilter);
                    } else {
                        CommitFilesChooser.this.getViewer().addFilter((ViewerFilter)CommitFilesChooser.this.untrackedFilesFilter);
                    }
                    CommitFilesChooser.this.getViewer().refresh(true);
                    CommitFilesChooser.this.fireStateChanged();
                }
            });
        }
        Table table = this.getViewer().getTable();
        TableColumn[] columns = table.getColumns();
        int ci = 0;
        while (ci < columns.length) {
            TableColumn column = columns[ci];
            final int colIdx = ci++;
            new TableColumnSorter((TableViewer)this.getViewer(), column){

                protected int doCompare(Viewer v, Object e1, Object e2) {
                    StructuredViewer v1 = (StructuredViewer)v;
                    ITableLabelProvider lp = (ITableLabelProvider)v1.getLabelProvider();
                    String t1 = lp.getColumnText(e1, colIdx);
                    String t2 = lp.getColumnText(e2, colIdx);
                    return t1.compareTo(t2);
                }
            };
        }
    }

    public void setResources(List<IResource> resources) {
        CommitResource[] commitResources;
        IResource[] res = resources.toArray(new IResource[0]);
        try {
            commitResources = new CommitResourceUtil().getCommitResources(res);
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
            commitResources = new CommitResource[]{};
        }
        this.getViewer().setInput((Object)commitResources);
        ArrayList<CommitResource> tracked = new ArrayList<CommitResource>();
        CommitResource[] commitResourceArray = commitResources;
        int n = commitResources.length;
        int n2 = 0;
        while (n2 < n) {
            CommitResource commitResource = commitResourceArray[n2];
            if ('?' != commitResource.getStatus()) {
                tracked.add(commitResource);
            }
            ++n2;
        }
        this.getViewer().setCheckedElements(tracked.toArray());
        if (!this.untracked) {
            this.selectAllButton.setSelection(true);
        }
    }

    public List<IResource> getCheckedResources(String ... status) {
        return this.getViewerResources(true, status);
    }

    public List<IResource> getUncheckedResources(String ... status) {
        return this.getViewerResources(false, status);
    }

    public List<IResource> getViewerResources(boolean checked, String ... status) {
        TableItem[] children = this.getViewer().getTable().getItems();
        ArrayList<IResource> list = new ArrayList<IResource>(children.length);
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            if (item.getChecked() == checked && item.getData() instanceof CommitResource) {
                CommitResource resource = (CommitResource)item.getData();
                if (status == null || status.length == 0) {
                    list.add(resource.getResource());
                } else {
                    String[] stringArray = status;
                    int n = status.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String stat = stringArray[n2];
                        if (resource.getStatusMessage().equals(stat)) {
                            list.add(resource.getResource());
                            break;
                        }
                        ++n2;
                    }
                }
            }
            ++i;
        }
        return list;
    }

    public void addStateListener(Listener listener) {
        this.stateListeners.add((Object)listener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.stateListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            ((Listener)obj).handleEvent(null);
            ++n2;
        }
    }

    private void closeSash() {
        if (this.tray == null) {
            throw new IllegalStateException("Tray was not open");
        }
        int trayWidth = this.trayControl.getSize().x + this.leftSeparator.getSize().x + this.sash.getSize().x + this.rightSeparator.getSize().x;
        this.trayControl.dispose();
        this.trayControl = null;
        this.tray = null;
        this.leftSeparator.dispose();
        this.leftSeparator = null;
        this.rightSeparator.dispose();
        this.rightSeparator = null;
        this.sash.dispose();
        this.sash = null;
        Shell shell = this.getShell();
        Rectangle bounds = shell.getBounds();
        shell.setBounds(bounds.x + (Window.getDefaultOrientation() == 0x4000000 ? trayWidth : 0), bounds.y, bounds.width - trayWidth, bounds.height);
    }

    private void showDiffForSelection() {
        if (this.trayClosed && this.selectedFile != null) {
            try {
                this.openSash();
                this.trayClosed = false;
            }
            catch (Exception e1) {
                MercurialEclipsePlugin.logError(e1);
            }
        } else {
            this.closeSash();
            this.trayClosed = true;
        }
    }
}

