/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.ui;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.ui.Messages;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ChangesetTable
extends Composite {
    private static final Font PARENT_FONT = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
    private final Table table;
    private int[] parents;
    private final IResource resource;
    private ChangeSet[] changesets = new ChangeSet[0];
    private int logBatchSize = LocalChangesetCache.getInstance().getLogBatchSize();
    private boolean autoFetch = true;
    private boolean bottomNotFetched = true;

    public ChangesetTable(Composite parent, IResource resource) {
        this(parent, 68356, resource);
    }

    public ChangesetTable(Composite parent, IResource resource, boolean autoFetch) {
        this(parent, 68356, resource);
        this.autoFetch = autoFetch;
    }

    public ChangesetTable(Composite parent, int tableStyle, IResource resource, boolean autoFetch) {
        this(parent, tableStyle, resource);
        this.autoFetch = autoFetch;
    }

    public ChangesetTable(Composite parent, int tableStyle, IResource resource) {
        super(parent, 0);
        this.resource = resource;
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData());
        this.table = new Table((Composite)this, tableStyle);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 150;
        data.minimumHeight = 50;
        this.table.setLayoutData((Object)data);
        String[] titles = new String[]{Messages.getString("ChangesetTable.column.rev"), Messages.getString("ChangesetTable.column.global"), Messages.getString("ChangesetTable.column.date"), Messages.getString("ChangesetTable.column.author"), Messages.getString("ChangesetTable.column.branch"), Messages.getString("ChangesetTable.column.summary")};
        int[] widths = new int[]{50, 150, 150, 100, 100, 300};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(titles[i]);
            column.setWidth(widths[i]);
            ++i;
        }
        Listener paintListener = new Listener(){

            public void paintControl(Event e) {
                TableItem tableItem = (TableItem)e.item;
                ChangeSet cs = (ChangeSet)tableItem.getData();
                if (ChangesetTable.this.table.isEnabled() && tableItem.equals(ChangesetTable.this.table.getItems()[ChangesetTable.this.table.getItemCount() - 1]) && cs.getChangesetIndex() > 0) {
                    ChangesetTable.this.logBatchSize = 200;
                    try {
                        int startRev = cs.getChangesetIndex() - 1;
                        ChangesetTable.this.updateTable(startRev);
                    }
                    catch (HgException e1) {
                        MercurialEclipsePlugin.logError((Throwable)((Object)e1));
                    }
                }
            }

            public void handleEvent(Event event) {
                this.paintControl(event);
            }
        };
        this.table.addListener(42, paintListener);
    }

    public void highlightParents(int[] newParents) {
        this.parents = newParents;
    }

    private void updateTable(int startRev) throws HgException {
        if (this.resource != null && this.table.isEnabled() && this.autoFetch) {
            SortedSet<ChangeSet> set;
            if (startRev - this.logBatchSize > 0 || this.bottomNotFetched) {
                LocalChangesetCache.getInstance().fetchLocalRevisions(this.resource, true, this.logBatchSize, startRev, false);
            }
            if ((set = LocalChangesetCache.getInstance().getLocalChangeSets(this.resource)).size() == 0 || set.first().getChangesetIndex() == 0) {
                this.bottomNotFetched = false;
            }
            TreeSet<ChangeSet> reverseOrderSet = new TreeSet<ChangeSet>(Collections.reverseOrder());
            reverseOrderSet.addAll(set);
            this.setChangesets(reverseOrderSet.toArray(new ChangeSet[reverseOrderSet.size()]));
        }
    }

    public void setChangesets(ChangeSet[] sets) {
        this.changesets = sets;
        int i = Math.max(0, this.table.getItemCount());
        while (i < sets.length) {
            ChangeSet rev = sets[i];
            TableItem row = new TableItem(this.table, 0);
            if (this.parents != null && this.isParent(rev.getChangesetIndex())) {
                row.setFont(PARENT_FONT);
            }
            row.setText(0, Integer.toString(rev.getChangesetIndex()));
            row.setText(1, rev.getChangeset());
            row.setText(2, rev.getDate());
            row.setText(3, rev.getUser());
            row.setText(4, rev.getBranch());
            row.setText(5, rev.getSummary());
            row.setData((Object)rev);
            ++i;
        }
        this.table.setItemCount(sets.length);
    }

    public ChangeSet[] getSelections() {
        TableItem[] selection = this.table.getSelection();
        if (selection.length == 0) {
            return null;
        }
        ChangeSet[] csArray = new ChangeSet[selection.length];
        int i = 0;
        while (i < selection.length) {
            csArray[i] = (ChangeSet)selection[i].getData();
            ++i;
        }
        return csArray;
    }

    public ChangeSet getSelection() {
        if (this.getSelections() != null) {
            return this.getSelections()[0];
        }
        return null;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.table.addSelectionListener(listener);
    }

    public void setEnabled(boolean enabled) {
        this.table.setEnabled(enabled);
        try {
            if (enabled) {
                this.updateTable(-1);
            }
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
        }
    }

    private boolean isParent(int r) {
        switch (this.parents.length) {
            case 2: {
                if (r == this.parents[1]) {
                    return true;
                }
            }
            case 1: {
                if (r != this.parents[0]) break;
                return true;
            }
        }
        return false;
    }

    public ChangeSet[] getChangesets() {
        return this.changesets;
    }

    public void setAutoFetch(boolean autoFetch) {
        this.autoFetch = autoFetch;
    }

    public boolean isAutoFetch() {
        return this.autoFetch;
    }
}

