/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.ui;

import com.vectrace.MercurialEclipse.model.Branch;
import com.vectrace.MercurialEclipse.ui.Messages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class BranchTable
extends Composite {
    private static final Font PARENT_FONT = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
    private Table table;
    private int[] parents;
    private boolean showTip = true;

    public BranchTable(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData());
        this.table = new Table((Composite)this, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)data);
        String[] titles = new String[]{Messages.getString("BranchTable.column.rev"), Messages.getString("BranchTable.column.global"), Messages.getString("BranchTable.column.branch"), Messages.getString("BranchTable.column.active")};
        int[] widths = new int[]{50, 150, 300, 70};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(titles[i]);
            column.setWidth(widths[i]);
            ++i;
        }
    }

    public void hideTip() {
        this.showTip = false;
    }

    public void highlightParents(int[] newParents) {
        this.parents = newParents;
    }

    public void setBranches(Branch[] branches) {
        this.table.removeAll();
        Branch[] branchArray = branches;
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            Branch branch = branchArray[n2];
            if (this.showTip || !"tip".equals(branch.getName())) {
                TableItem row = new TableItem(this.table, 0);
                if (this.parents != null && this.isParent(branch.getRevision())) {
                    row.setFont(PARENT_FONT);
                }
                row.setText(0, Integer.toString(branch.getRevision()));
                row.setText(1, branch.getGlobalId());
                row.setText(2, branch.getName());
                row.setText(3, branch.isActive() ? Messages.getString("BranchTable.stateActive") : Messages.getString("BranchTable.stateInactive"));
                row.setData((Object)branch);
            }
            ++n2;
        }
    }

    public Branch getSelection() {
        TableItem[] selection = this.table.getSelection();
        if (selection.length == 0) {
            return null;
        }
        return (Branch)selection[0].getData();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.table.addSelectionListener(listener);
    }

    private boolean isParent(int r) {
        switch (this.parents.length) {
            case 2: {
                if (r == this.parents[1]) {
                    return true;
                }
            }
            case 1: {
                if (r != this.parents[0]) break;
                return true;
            }
        }
        return false;
    }
}

