/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.ui;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.extensions.HgBookmarkClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.Bookmark;
import com.vectrace.MercurialEclipse.ui.Messages;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class BookmarkTable
extends Composite {
    private static final Font PARENT_FONT = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
    private Table table;
    private IResource res;

    public BookmarkTable(Composite parent, IResource res) {
        super(parent, 0);
        this.res = res;
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData());
        this.table = new Table((Composite)this, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 150;
        data.minimumHeight = 50;
        this.table.setLayoutData((Object)data);
        String[] titles = new String[]{Messages.getString("BookmarkTable.column.rev"), Messages.getString("BookmarkTable.column.global"), Messages.getString("BookmarkTable.column.name"), Messages.getString("BookmarkTable.column.state")};
        int[] widths = new int[]{50, 150, 300, 70};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(titles[i]);
            column.setWidth(widths[i]);
            ++i;
        }
        this.updateTable();
    }

    private void updateTable() {
        try {
            List<Bookmark> bookmarks = HgBookmarkClient.getBookmarks(this.res.getLocation().toFile());
            this.setBookmarks(bookmarks.toArray(new Bookmark[bookmarks.size()]));
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
        }
    }

    public void setBookmarks(Bookmark[] bookmarks) {
        this.table.removeAll();
        Bookmark[] bookmarkArray = bookmarks;
        int n = bookmarks.length;
        int n2 = 0;
        while (n2 < n) {
            Bookmark bm = bookmarkArray[n2];
            TableItem row = new TableItem(this.table, 0);
            row.setText(0, Integer.toString(bm.getRevision()));
            row.setText(1, bm.getShortNodeId());
            row.setText(2, bm.getName());
            row.setText(3, bm.isActive() ? Messages.getString("BookmarkTable.stateActive") : Messages.getString("BookmarkTable.stateInactive"));
            row.setData((Object)bm);
            if (bm.isActive()) {
                row.setFont(PARENT_FONT);
            }
            ++n2;
        }
    }

    public Bookmark getSelection() {
        TableItem[] selection = this.table.getSelection();
        if (selection.length == 0) {
            return null;
        }
        return (Bookmark)selection[0].getData();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.table.addSelectionListener(listener);
    }
}

