/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team.cache;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgIncomingClient;
import com.vectrace.MercurialEclipse.commands.HgOutgoingClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCache
extends Observable {
    private final Map<IProject, Map<String, ChangeSet>> changesets = new HashMap<IProject, Map<String, ChangeSet>>();
    protected final boolean debug = MercurialEclipsePlugin.getDefault().isDebugging();

    public AbstractCache() {
        final IPreferenceStore store = MercurialEclipsePlugin.getDefault().getPreferenceStore();
        this.configureFromPreferences(store);
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                AbstractCache.this.configureFromPreferences(store);
            }
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() != 1) {
                    return;
                }
                try {
                    ProjectDeltaVisitor visitor = new ProjectDeltaVisitor();
                    event.getDelta().accept((IResourceDeltaVisitor)visitor);
                }
                catch (CoreException e) {
                    MercurialEclipsePlugin.logError(e);
                }
            }
        }, 1);
    }

    protected void clearProjectCache(IProject project) {
        this.clearChangesets(project);
    }

    protected void configureFromPreferences(IPreferenceStore store) {
    }

    protected void addResourcesToCache(IProject project, HgRepositoryLocation repository, Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> changeSetMap, ChangeSet.Direction direction) throws HgException {
        Map<IPath, SortedSet<ChangeSet>> removeMap;
        if (this.debug) {
            System.out.println("\n!fetch " + (Object)((Object)direction) + " for " + project);
        }
        if ((removeMap = changeSetMap.get(repository)) != null) {
            removeMap.clear();
            changeSetMap.remove(repository);
        }
        Map<IPath, SortedSet<ChangeSet>> resources = direction == ChangeSet.Direction.OUTGOING ? HgOutgoingClient.getOutgoing((IResource)project, repository) : HgIncomingClient.getHgIncoming((IResource)project, repository);
        HashMap<IPath, SortedSet<Object>> map = new HashMap<IPath, SortedSet<Object>>();
        changeSetMap.put(repository, map);
        IPath projectPath = project.getLocation();
        map.put(projectPath, new TreeSet());
        for (Map.Entry<IPath, SortedSet<ChangeSet>> mapEntry : resources.entrySet()) {
            IPath path = mapEntry.getKey();
            SortedSet<ChangeSet> changes = mapEntry.getValue();
            if (changes == null || changes.size() <= 0) continue;
            this.addChangesets(project, changes);
            map.put(path, changes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChangesets(IProject project, Set<ChangeSet> changes) {
        Map<IProject, Map<String, ChangeSet>> map = this.changesets;
        synchronized (map) {
            Map<String, ChangeSet> map2 = this.changesets.get(project);
            if (map2 == null) {
                map2 = new ConcurrentHashMap<String, ChangeSet>();
                this.changesets.put(project, map2);
            }
            for (ChangeSet changeSet : changes) {
                map2.put(changeSet.toString(), changeSet);
                map2.put(changeSet.getChangeset(), changeSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeSet getChangeset(IProject project, String changesetId) {
        Map<String, ChangeSet> map;
        Map<IProject, Map<String, ChangeSet>> map2 = this.changesets;
        synchronized (map2) {
            map = this.changesets.get(project);
        }
        if (map != null) {
            return map.get(changesetId);
        }
        return null;
    }

    protected void notifyChanged(IResource resource, boolean expandMembers) {
        HashSet<IResource> resources = new HashSet<IResource>();
        resources.add(resource);
        this.notifyChanged(resources, expandMembers);
    }

    protected void notifyChanged(final Set<IResource> resources, final boolean expandMembers) {
        Job job = new Job("hg cache clients update..."){

            protected IStatus run(IProgressMonitor monitor) {
                HashSet<IResource> set;
                if (!expandMembers) {
                    set = resources;
                } else {
                    set = new HashSet<IResource>(resources);
                    for (IResource r : resources) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        set.addAll(AbstractCache.this.getMembers(r));
                    }
                }
                AbstractCache.this.setChanged();
                AbstractCache.this.notifyObservers(set);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected Set<IResource> getMembers(IResource r) {
        HashSet<IResource> set = new HashSet<IResource>();
        if (r instanceof IContainer && r.isAccessible()) {
            IContainer cont = (IContainer)r;
            try {
                IResource[] members = cont.members();
                if (members != null) {
                    IResource[] iResourceArray = members;
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        if (member instanceof IContainer) {
                            set.addAll(this.getMembers(member));
                        } else {
                            set.add(member);
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
        set.add(r);
        return set;
    }

    protected Set<IResource> getMembers(IResource resource, Map<IPath, SortedSet<ChangeSet>> changeSets) {
        HashSet<IResource> members = new HashSet<IResource>();
        if (changeSets == null) {
            return members;
        }
        IWorkspaceRoot root = resource.getWorkspace().getRoot();
        IPath location = ResourceUtils.getPath(resource);
        for (IPath path : changeSets.keySet()) {
            IPath memberLocation;
            IFile member = root.getFileForLocation(path);
            if (member == null || !location.isPrefixOf(memberLocation = ResourceUtils.getPath((IResource)member))) continue;
            members.add((IResource)member);
        }
        return members;
    }

    public IResource convertRepoRelPath(HgRoot hgRoot, IProject project, String repoRelPath) {
        String resourceLocation = String.valueOf(hgRoot.getAbsolutePath()) + File.separator + repoRelPath;
        Path path = new Path(resourceLocation);
        int equalSegments = path.matchingFirstSegments(project.getLocation());
        path = path.removeFirstSegments(equalSegments);
        return project.findMember((IPath)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean clearChangesets(IProject project) {
        Map<IProject, Map<String, ChangeSet>> map = this.changesets;
        synchronized (map) {
            Map<String, ChangeSet> map2 = this.changesets.remove(project);
            return map2 != null && !map2.isEmpty();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private class ProjectDeltaVisitor
    implements IResourceDeltaVisitor {
        private ProjectDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            if (res.getType() == 8) {
                return true;
            }
            if (res.getType() != 4) {
                return false;
            }
            IProject project = (IProject)res;
            if (delta.getKind() == 2 || (delta.getFlags() & 0x4000) != 0 && !project.isOpen()) {
                AbstractCache.this.clearProjectCache(project);
            }
            return false;
        }
    }
}

