/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgCatClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.Messages;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.utils.PatchUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MercurialRevisionStorage
implements IStorage {
    private static final ByteArrayInputStream EMPTY_STREAM = new ByteArrayInputStream(new byte[0]);
    private int revision;
    private String global;
    private final IResource resource;
    protected ChangeSet changeSet;
    protected ContentHolder content;
    private File parent;

    public MercurialRevisionStorage(IResource res, String changeset) {
        this.resource = res;
        try {
            this.changeSet = LocalChangesetCache.getInstance().getLocalChangeSet(res, changeset);
            if (this.changeSet != null) {
                this.revision = this.changeSet.getChangesetIndex();
                this.global = this.changeSet.getChangeset();
            }
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
        }
    }

    public MercurialRevisionStorage(IResource res, int rev, String global, ChangeSet cs) {
        this.revision = rev;
        this.global = global;
        this.resource = res;
        this.changeSet = cs;
    }

    public MercurialRevisionStorage(IResource res) {
        this.resource = res;
        ChangeSet cs = null;
        try {
            cs = LocalChangesetCache.getInstance().getCurrentWorkDirChangeset(res);
            this.revision = cs.getChangesetIndex();
            this.global = cs.getChangeset();
            this.changeSet = cs;
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
        }
    }

    public void setParent(File parent) {
        this.parent = parent;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IResource.class)) {
            return this.resource;
        }
        return null;
    }

    public InputStream getContents() throws CoreException {
        if (this.content != null) {
            return this.content.createStream();
        }
        try {
            IFile file = this.resource.getProject().getFile(this.resource.getProjectRelativePath());
            this.content = this.fetchContent(file);
        }
        catch (CoreException e) {
            if (this.parent != null) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.parent.getAbsolutePath()));
                try {
                    this.content = this.fetchContent(file);
                    return this.content.createStream();
                }
                catch (CoreException e2) {
                    e = e2;
                }
            }
            this.content = new ContentHolder(e);
            MercurialEclipsePlugin.logWarning("Failed to get revision content for " + this.toString(), e);
            throw e;
        }
        return this.content.createStream();
    }

    private ContentHolder fetchContent(IFile file) throws CoreException {
        String result;
        if (this.changeSet == null) {
            return new ContentHolder(HgCatClient.getContent(file, null));
        }
        if (this.changeSet.getDirection() == ChangeSet.Direction.INCOMING && this.changeSet.getBundleFile() != null) {
            try {
                result = HgCatClient.getContentFromBundle(file, Integer.valueOf(this.changeSet.getChangesetIndex()).toString(), this.changeSet.getBundleFile().getCanonicalPath());
            }
            catch (IOException e) {
                throw new HgException("Unable to determine canonical path for " + this.changeSet.getBundleFile(), e);
            }
        } else {
            if (this.changeSet.getDirection() == ChangeSet.Direction.OUTGOING) {
                return new ContentHolder(PatchUtils.getPatchedContentsAsBytes(file, this.changeSet.getPatches(), true));
            }
            if (MercurialStatusCache.getInstance().isUnknown((IResource)file)) {
                return new ContentHolder(null);
            }
            result = HgCatClient.getContent(file, Integer.valueOf(this.changeSet.getChangesetIndex()).toString());
        }
        return new ContentHolder(result);
    }

    public IPath getFullPath() {
        return this.resource.getFullPath().append(this.revision != 0 ? " [" + this.revision + "]" : Messages.getString("MercurialRevisionStorage.parentChangeset"));
    }

    public String getName() {
        try {
            this.getContents();
        }
        catch (CoreException e) {
            this.content = new ContentHolder(e);
        }
        String name = this.changeSet != null ? String.valueOf(this.resource.getName()) + " [" + this.changeSet.toString() + "]" : this.resource.getName();
        if (this.content.error != null) {
            String message = this.content.error.getMessage();
            name = message.indexOf(10) > 0 ? message.substring(0, message.indexOf(10)) : message;
        }
        return name;
    }

    public int getRevision() {
        return this.revision;
    }

    public boolean isReadOnly() {
        if (this.revision != 0) {
            return true;
        }
        ResourceAttributes attributes = this.resource.getResourceAttributes();
        if (attributes != null) {
            return attributes.isReadOnly();
        }
        return true;
    }

    public IResource getResource() {
        return this.resource;
    }

    public String getGlobal() {
        return this.global;
    }

    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    public MercurialRevisionStorage(IResource res, int rev) {
        this(res, String.valueOf(rev));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Hg revision [");
        if (this.changeSet != null) {
            builder.append("changeSet=");
            builder.append(this.changeSet);
            builder.append(", ");
        }
        if (this.revision != 0) {
            builder.append("revision=");
            builder.append(this.revision);
            builder.append(", ");
        }
        if (this.global != null) {
            builder.append("global=");
            builder.append(this.global);
            builder.append(", ");
        }
        if (this.resource != null) {
            builder.append("resource=");
            builder.append(this.resource);
            builder.append(", ");
        }
        if (this.parent != null) {
            builder.append("parent=");
            builder.append(this.parent);
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    protected class ContentHolder {
        private final byte[] bytes;
        private final String string;
        private Throwable error;

        private ContentHolder(byte[] b, String str, Throwable t) {
            this.bytes = b;
            this.string = str;
            this.error = t;
        }

        public ContentHolder(byte[] bytes) {
            this(bytes, null, null);
        }

        public ContentHolder(String string) {
            this(null, string, null);
        }

        public ContentHolder(Throwable t) {
            this(null, null, t);
        }

        private InputStream createStreamContent(String result) throws HgException {
            try {
                HgRoot root = MercurialTeamProvider.getHgRoot(MercurialRevisionStorage.this.resource);
                return new ByteArrayInputStream(result.getBytes(root.getEncoding().name()));
            }
            catch (UnsupportedEncodingException e) {
                this.error = e;
                MercurialEclipsePlugin.logWarning("Failed to get revision content for " + MercurialRevisionStorage.this.toString(), e);
                return EMPTY_STREAM;
            }
        }

        public InputStream createStream() throws HgException {
            if (this.bytes != null) {
                return new ByteArrayInputStream(this.bytes);
            }
            if (this.string != null && this.error == null) {
                return this.createStreamContent(this.string);
            }
            return EMPTY_STREAM;
        }
    }
}

