/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.synchronize;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeChangeListener;
import org.eclipse.team.internal.ui.Utils;

public class RepositorySynchronizationScope
implements ISynchronizationScope {
    private final IResource[] roots;
    private final ListenerList listeners;
    private final HgRepositoryLocation repo;

    public RepositorySynchronizationScope(HgRepositoryLocation repo, IResource[] roots) {
        this.repo = repo;
        this.roots = roots != null ? roots : MercurialEclipsePlugin.getRepoManager().getAllRepoLocationProjects(repo).toArray(new IResource[0]);
        this.listeners = new ListenerList(1);
    }

    public void addScopeChangeListener(ISynchronizationScopeChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public ISynchronizationScope asInputScope() {
        return this;
    }

    public boolean contains(IResource resource) {
        ResourceTraversal[] traversals = this.getTraversals();
        if (traversals == null) {
            return false;
        }
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            if (traversal.contains(resource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ResourceMappingContext getContext() {
        return ResourceMappingContext.LOCAL_CONTEXT;
    }

    public ResourceMapping[] getInputMappings() {
        return Utils.getResourceMappings((Object[])this.getRoots());
    }

    public ResourceMapping getMapping(Object modelObject) {
        ResourceMapping[] mappings;
        ResourceMapping[] resourceMappingArray = mappings = this.getMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if (mapping.getModelObject().equals(modelObject)) {
                return mapping;
            }
            ++n2;
        }
        return null;
    }

    public ResourceMapping[] getMappings() {
        return this.getInputMappings();
    }

    public ResourceMapping[] getMappings(String modelProviderId) {
        ResourceMapping[] mappings;
        if (!this.isSupportedModelProvider(modelProviderId)) {
            return null;
        }
        HashSet<ResourceMapping> result = new HashSet<ResourceMapping>();
        ResourceMapping[] resourceMappingArray = mappings = this.getMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if (mapping.getModelProviderId().equals(modelProviderId)) {
                result.add(mapping);
            }
            ++n2;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    private boolean isSupportedModelProvider(String modelProviderId) {
        return "org.eclipse.core.resources.modelProvider".equals(modelProviderId);
    }

    public ModelProvider[] getModelProviders() {
        ResourceMapping[] mappings;
        HashSet<ModelProvider> result = new HashSet<ModelProvider>();
        ResourceMapping[] resourceMappingArray = mappings = this.getMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            ModelProvider modelProvider = mapping.getModelProvider();
            if (modelProvider != null && this.isSupportedModelProvider(modelProvider.getId())) {
                result.add(modelProvider);
            }
            ++n2;
        }
        return result.toArray(new ModelProvider[result.size()]);
    }

    public IProject[] getProjects() {
        HashSet<IProject> projects = new HashSet<IProject>();
        IResource[] iResourceArray = this.roots;
        int n = this.roots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            projects.add(res.getProject());
            ++n2;
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public IResource[] getRoots() {
        return this.roots;
    }

    public ResourceTraversal[] getTraversals() {
        return new ResourceTraversal[]{new ResourceTraversal(this.getRoots(), 2, 4)};
    }

    public ResourceTraversal[] getTraversals(ResourceMapping mapping) {
        try {
            return mapping.getTraversals(this.getContext(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
            return null;
        }
    }

    public ResourceTraversal[] getTraversals(String modelProviderId) {
        return null;
    }

    public boolean hasAdditionalMappings() {
        return false;
    }

    public boolean hasAdditonalResources() {
        return false;
    }

    public void refresh(ResourceMapping[] mappings) {
        if (!this.listeners.isEmpty()) {
            Object[] objects;
            Object[] objectArray = objects = this.listeners.getListeners();
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                ((ISynchronizationScopeChangeListener)object).scopeChanged((ISynchronizationScope)this, mappings, this.getTraversals());
                ++n2;
            }
        }
    }

    public void removeScopeChangeListener(ISynchronizationScopeChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public HgRepositoryLocation getRepositoryLocation() {
        return this.repo;
    }
}

