/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.synchronize;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgIdentClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.synchronize.MercurialResourceVariant;
import com.vectrace.MercurialEclipse.synchronize.MercurialResourceVariantComparator;
import com.vectrace.MercurialEclipse.synchronize.MercurialSyncInfo;
import com.vectrace.MercurialEclipse.synchronize.Messages;
import com.vectrace.MercurialEclipse.synchronize.RepositorySynchronizationScope;
import com.vectrace.MercurialEclipse.team.MercurialRevisionStorage;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.cache.IncomingChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.team.cache.OutgoingChangesetCache;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariantComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialSynchronizeSubscriber
extends Subscriber {
    private static final LocalChangesetCache LOCAL_CACHE = LocalChangesetCache.getInstance();
    private static final IncomingChangesetCache INCOMING_CACHE = IncomingChangesetCache.getInstance();
    private static final OutgoingChangesetCache OUTGOING_CACHE = OutgoingChangesetCache.getInstance();
    private static final MercurialStatusCache STATUS_CACHE = MercurialStatusCache.getInstance();
    private final boolean debug = MercurialEclipsePlugin.getDefault().isDebugging();
    private final ISynchronizationScope scope;
    private IResource[] myRoots;
    private IResourceVariantComparator comparator;
    private final Semaphore sema;

    public MercurialSynchronizeSubscriber(ISynchronizationScope synchronizationScope) {
        this.scope = synchronizationScope;
        this.sema = new Semaphore(1, true);
    }

    public String getName() {
        return Messages.getString("MercurialSynchronizeSubscriber.repoWatcher");
    }

    public IResourceVariantComparator getResourceComparator() {
        if (this.comparator == null) {
            this.comparator = new MercurialResourceVariantComparator();
        }
        return this.comparator;
    }

    public SyncInfo getSyncInfo(IResource resource) {
        boolean fileRemoved;
        ChangeSet csIncoming;
        MercurialResourceVariant outgoing;
        MercurialRevisionStorage outgoingIStorage;
        ChangeSet csOutgoing;
        if (!this.isInteresting(resource)) {
            return null;
        }
        HgRepositoryLocation repositoryLocation = this.getRepo(resource);
        try {
            if (!this.sema.tryAcquire(300L, TimeUnit.SECONDS)) {
                return null;
            }
        }
        catch (InterruptedException e) {
            MercurialEclipsePlugin.logError(e);
            return null;
        }
        try {
            try {
                csOutgoing = OUTGOING_CACHE.getNewestOutgoingChangeSet(resource, repositoryLocation);
            }
            catch (HgException e) {
                MercurialEclipsePlugin.logError((Throwable)((Object)e));
                this.sema.release();
                return null;
            }
        }
        finally {
            this.sema.release();
        }
        if (csOutgoing != null) {
            outgoingIStorage = new MercurialRevisionStorage(resource, csOutgoing.getRevision().getRevision(), csOutgoing.getChangeset(), csOutgoing);
            outgoing = new MercurialResourceVariant(outgoingIStorage);
        } else {
            boolean exists = resource.exists();
            if (exists && !STATUS_CACHE.isAdded(resource.getLocation()) || !exists && STATUS_CACHE.isRemoved(resource)) {
                try {
                    HgRoot root = MercurialTeamProvider.getHgRoot(resource);
                    String nodeId = HgIdentClient.getCurrentChangesetId(root);
                    csOutgoing = LOCAL_CACHE.getChangeset(resource.getProject(), nodeId);
                    if (csOutgoing == null) {
                        csOutgoing = LOCAL_CACHE.getLocalChangeSet(resource, nodeId);
                    }
                }
                catch (HgException e) {
                    MercurialEclipsePlugin.logError((Throwable)((Object)e));
                    return null;
                }
                outgoingIStorage = new MercurialRevisionStorage(resource, csOutgoing.getChangesetIndex(), csOutgoing.getChangeset(), csOutgoing);
                outgoing = new MercurialResourceVariant(outgoingIStorage);
            } else {
                outgoingIStorage = null;
                outgoing = null;
            }
        }
        try {
            if (!this.sema.tryAcquire(300L, TimeUnit.SECONDS)) {
                return null;
            }
        }
        catch (InterruptedException e) {
            MercurialEclipsePlugin.logError(e);
            return null;
        }
        try {
            try {
                csIncoming = INCOMING_CACHE.getNewestIncomingChangeSet(resource, repositoryLocation);
            }
            catch (HgException e) {
                MercurialEclipsePlugin.logError((Throwable)((Object)e));
                this.sema.release();
                return null;
            }
        }
        finally {
            this.sema.release();
        }
        Object incomingIStorage = csIncoming != null ? ((fileRemoved = csIncoming.isRemoved(resource)) ? null : this.getIncomingIStorage(resource, csIncoming)) : outgoingIStorage;
        MercurialResourceVariant incoming = incomingIStorage != null ? new MercurialResourceVariant((MercurialRevisionStorage)incomingIStorage) : null;
        MercurialSyncInfo info = new MercurialSyncInfo(resource, outgoing, incoming, this.getResourceComparator());
        try {
            info.init();
            return info;
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
            return null;
        }
    }

    private boolean isInteresting(IResource resource) {
        return resource != null && RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") != null && (this.isSupervised(resource) || !resource.exists());
    }

    private MercurialRevisionStorage getIncomingIStorage(IResource resource, ChangeSet csRemote) {
        MercurialRevisionStorage incomingIStorage = new MercurialRevisionStorage(resource, csRemote.getRevision().getRevision(), csRemote.getChangeset(), csRemote);
        return incomingIStorage;
    }

    public boolean isSupervised(IResource resource) {
        return resource.getType() == 1 && MercurialUtilities.isPossiblySupervised(resource);
    }

    public IResource[] members(IResource resource) throws TeamException {
        return new IResource[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh(IResource[] resources, int flag, IProgressMonitor monitor) throws TeamException {
        List<ISubscriberChangeEvent> changeEvents;
        if (resources == null) {
            return;
        }
        Map<IProject, List<IResource>> byProject = ResourceUtils.groupByProject(Arrays.asList(resources));
        Set<IProject> projects = byProject.keySet();
        if (projects.isEmpty()) {
            return;
        }
        HashSet<IResource> resourcesToRefresh = new HashSet<IResource>();
        Iterator<IProject> iterator = projects.iterator();
        while (true) {
            block12: {
                block11: {
                    if (!iterator.hasNext()) {
                        changeEvents = this.createEvents(resources, resourcesToRefresh);
                        monitor.worked(1);
                        if (!monitor.isCanceled()) break;
                        return;
                    }
                    IProject project = iterator.next();
                    HgRepositoryLocation repositoryLocation = this.getRepo((IResource)project);
                    if (repositoryLocation == null) continue;
                    monitor.beginTask(this.getName(), 5);
                    boolean forceRefresh = project.exists();
                    try {
                        this.sema.acquire();
                        if (this.debug) {
                            System.out.println("going to refresh local/in/out: " + project + ", depth: " + flag);
                        }
                        monitor.subTask(Messages.getString("MercurialSynchronizeSubscriber.refreshingLocal"));
                        this.refreshLocal(flag, monitor, project, forceRefresh);
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            break block11;
                        }
                    }
                    catch (InterruptedException e) {
                        MercurialEclipsePlugin.logError(e);
                        this.sema.release();
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.sema.release();
                        throw throwable;
                    }
                    {
                        monitor.subTask(Messages.getString("MercurialSynchronizeSubscriber.refreshingIncoming"));
                        this.refreshIncoming(flag, resourcesToRefresh, project, repositoryLocation, forceRefresh);
                        monitor.worked(1);
                        if (monitor.isCanceled()) break block11;
                        monitor.subTask(Messages.getString("MercurialSynchronizeSubscriber.refreshingOutgoing"));
                        this.refreshOutgoing(flag, resourcesToRefresh, project, repositoryLocation, forceRefresh);
                        monitor.worked(1);
                        if (!monitor.isCanceled()) break block12;
                    }
                }
                this.sema.release();
                return;
            }
            this.sema.release();
        }
        monitor.subTask(Messages.getString("MercurialSynchronizeSubscriber.triggeringStatusCalc"));
        this.fireTeamResourceChange(changeEvents.toArray(new ISubscriberChangeEvent[changeEvents.size()]));
        monitor.worked(1);
        monitor.done();
    }

    private List<ISubscriberChangeEvent> createEvents(IResource[] resources, Set<IResource> resourcesToRefresh) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 1) {
                resourcesToRefresh.add(resource);
            } else {
                Set<IFile> localMembers = STATUS_CACHE.getLocalMembers(resource);
                resourcesToRefresh.addAll(localMembers);
            }
            ++n2;
        }
        ArrayList<ISubscriberChangeEvent> changeEvents = new ArrayList<ISubscriberChangeEvent>();
        for (IResource res : resourcesToRefresh) {
            changeEvents.add((ISubscriberChangeEvent)new SubscriberChangeEvent((Subscriber)this, 1, res));
        }
        return changeEvents;
    }

    private void refreshLocal(int flag, IProgressMonitor monitor, IProject project, boolean forceRefresh) throws HgException {
        if (flag == -3 || flag >= 0) {
            STATUS_CACHE.clear(project, false);
            if (forceRefresh) {
                STATUS_CACHE.refreshStatus((IResource)project, monitor);
            }
        }
    }

    private void refreshIncoming(int flag, Set<IResource> resourcesToRefresh, IProject project, HgRepositoryLocation repositoryLocation, boolean forceRefresh) throws HgException {
        if (flag == -1 || flag >= 0) {
            if (this.debug) {
                System.out.println("\nclear incoming: " + project + ", depth: " + flag);
            }
            INCOMING_CACHE.clear(repositoryLocation, project, false);
        }
        if (forceRefresh && flag != -2) {
            if (this.debug) {
                System.out.println("\nget incoming: " + project + ", depth: " + flag);
            }
            Set<IResource> incomingMembers = INCOMING_CACHE.getIncomingMembers((IResource)project, repositoryLocation);
            resourcesToRefresh.addAll(incomingMembers);
        }
    }

    private void refreshOutgoing(int flag, Set<IResource> resourcesToRefresh, IProject project, HgRepositoryLocation repositoryLocation, boolean forceRefresh) throws HgException {
        if (flag == -2 || flag >= 0) {
            if (this.debug) {
                System.out.println("\nclear outgoing: " + project + ", depth: " + flag);
            }
            OUTGOING_CACHE.clear(repositoryLocation, project, false);
        }
        if (forceRefresh && flag != -1) {
            if (this.debug) {
                System.out.println("\nget outgoing: " + project + ", depth: " + flag);
            }
            Set<IResource> outgoingMembers = OUTGOING_CACHE.getOutgoingMembers((IResource)project, repositoryLocation);
            resourcesToRefresh.addAll(outgoingMembers);
        }
    }

    protected HgRepositoryLocation getRepo(IResource resource) {
        if (this.scope instanceof RepositorySynchronizationScope) {
            RepositorySynchronizationScope repoScope = (RepositorySynchronizationScope)this.scope;
            return repoScope.getRepositoryLocation();
        }
        return MercurialEclipsePlugin.getRepoManager().getDefaultProjectRepoLocation(resource.getProject());
    }

    public IResource[] roots() {
        if (this.myRoots == null) {
            this.myRoots = this.scope != null && this.scope.getRoots() != null ? this.scope.getRoots() : MercurialStatusCache.getInstance().getAllManagedProjects();
        }
        return this.myRoots;
    }

    public void fireTeamResourceChange(ISubscriberChangeEvent[] deltas) {
        super.fireTeamResourceChange(deltas);
    }
}

