/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.synchronize;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.synchronize.HgSubscriberMergeContext;
import com.vectrace.MercurialEclipse.synchronize.HgSubscriberScopeManager;
import com.vectrace.MercurialEclipse.synchronize.MercurialSynchronizeSubscriber;
import com.vectrace.MercurialEclipse.synchronize.Messages;
import com.vectrace.MercurialEclipse.synchronize.RepositorySynchronizationScope;
import com.vectrace.MercurialEclipse.synchronize.actions.MercurialSynchronizePageActionGroup;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipantActionGroup;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;

public class MercurialSynchronizeParticipant
extends ModelSynchronizeParticipant {
    private static final String REPOSITORY_LOCATION = "REPOSITORY_LOCATION";
    private static final String PROJECTS = "PROJECTS";
    private String secondaryId;
    private HgRepositoryLocation repositoryLocation;
    private Set<IProject> restoredProjects;

    public MercurialSynchronizeParticipant() {
    }

    public MercurialSynchronizeParticipant(MergeContext ctx, HgRepositoryLocation repositoryLocation) {
        super((SynchronizationContext)ctx);
        this.repositoryLocation = repositoryLocation;
        this.secondaryId = repositoryLocation.getLocation();
        try {
            ISynchronizeParticipantDescriptor descriptor = TeamUI.getSynchronizeManager().getParticipantDescriptor(this.getId());
            this.setInitializationData(descriptor);
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
        }
    }

    public void init(String secId, IMemento memento) throws PartInitException {
        this.secondaryId = secId;
        IMemento myMemento = memento.getChild(MercurialSynchronizeParticipant.class.getName());
        String uri = myMemento.getString(REPOSITORY_LOCATION);
        try {
            this.repositoryLocation = MercurialEclipsePlugin.getRepoManager().getRepoLocation(uri);
        }
        catch (URISyntaxException e) {
            throw new PartInitException(e.getLocalizedMessage(), (Throwable)e);
        }
        this.restoreScope(myMemento);
        super.init(this.secondaryId, memento);
    }

    private void restoreScope(IMemento memento) {
        String encodedProjects = memento.getString(PROJECTS);
        if (encodedProjects == null) {
            return;
        }
        String[] projectNames = encodedProjects.split(",");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Set<IProject> repoProjects = MercurialEclipsePlugin.getRepoManager().getAllRepoLocationProjects(this.repositoryLocation);
        this.restoredProjects = new HashSet<IProject>();
        String[] stringArray = projectNames;
        int n = projectNames.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project;
            String pName = stringArray[n2];
            if (pName.length() != 0 && (project = root.getProject(pName)) != null && repoProjects.contains(project)) {
                this.restoredProjects.add(project);
            }
            ++n2;
        }
    }

    public void saveState(IMemento memento) {
        IMemento myMemento = memento.createChild(MercurialSynchronizeParticipant.class.getName());
        myMemento.putString(REPOSITORY_LOCATION, this.repositoryLocation.getSaveString());
        this.saveCurrentScope(myMemento);
        super.saveState(memento);
    }

    private void saveCurrentScope(IMemento memento) {
        IProject[] projects = this.getContext().getScope().getProjects();
        Set<IProject> repoProjects = MercurialEclipsePlugin.getRepoManager().getAllRepoLocationProjects(this.repositoryLocation);
        StringBuilder sb = new StringBuilder();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (repoProjects.contains(project)) {
                sb.append(project.getName()).append(",");
            }
            ++n2;
        }
        memento.putString(PROJECTS, sb.toString());
    }

    protected MergeContext restoreContext(ISynchronizationScopeManager manager) throws CoreException {
        Set<IProject> repoProjects = this.restoredProjects != null && !this.restoredProjects.isEmpty() ? this.restoredProjects : MercurialEclipsePlugin.getRepoManager().getAllRepoLocationProjects(this.repositoryLocation);
        RepositorySynchronizationScope scope = new RepositorySynchronizationScope(this.repositoryLocation, (IResource[])repoProjects.toArray(new IProject[0]));
        MercurialSynchronizeSubscriber subscriber = new MercurialSynchronizeSubscriber(scope);
        HgSubscriberScopeManager manager2 = new HgSubscriberScopeManager(scope.getMappings(), subscriber);
        return new HgSubscriberMergeContext(subscriber, (ISynchronizationScopeManager)manager2);
    }

    protected void initializeContext(SynchronizationContext context) {
        if (context != null) {
            super.initializeContext(context);
        }
    }

    public void dispose() {
        if (this.getContext() != null) {
            super.dispose();
        }
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getSecondaryId() {
        return this.secondaryId;
    }

    public String getName() {
        return String.valueOf(Messages.getString("MercurialSynchronizeParticipant.syncOnRepo")) + this.repositoryLocation;
    }

    public HgRepositoryLocation getRepositoryLocation() {
        return this.repositoryLocation;
    }

    protected ModelSynchronizeParticipantActionGroup createMergeActionGroup() {
        return new MercurialSynchronizePageActionGroup();
    }

    protected boolean isViewerContributionsSupported() {
        return true;
    }
}

