/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.operations;

import com.vectrace.MercurialEclipse.SafeUiJob;
import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.commands.extensions.mq.HgQImportClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.operations.Messages;
import com.vectrace.MercurialEclipse.views.PatchQueueView;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableContext;

public class QImportOperation
extends HgOperation {
    private IPath patchFile;
    private ChangeSet[] changesets;
    private boolean existing;
    private boolean git;
    private boolean force;
    private IResource resource;

    public QImportOperation(IRunnableContext context, IPath patchFile, ChangeSet[] changesets, boolean existing, boolean git, boolean force, IResource resource) {
        super(context);
        this.patchFile = patchFile;
        this.changesets = changesets;
        this.existing = existing;
        this.git = git;
        this.force = force;
        this.resource = resource;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(this.getActionDescription(), 3);
        try {
            monitor.worked(1);
            monitor.subTask(Messages.getString("QImportOperation.call"));
            HgQImportClient.qimport(this.resource, this.force, this.git, this.existing, this.changesets, this.patchFile);
            monitor.worked(1);
            monitor.subTask(Messages.getString("QImportOperation.refreshingView"));
            new SafeUiJob(Messages.getString("QImportOperation.refreshingView")){

                protected IStatus runSafe(IProgressMonitor monitor) {
                    PatchQueueView.getView().populateTable();
                    return super.runSafe(monitor);
                }
            }.schedule();
            monitor.worked(1);
        }
        catch (HgException e) {
            throw new InvocationTargetException((Throwable)((Object)e), e.getLocalizedMessage());
        }
        monitor.done();
    }

    protected String getActionDescription() {
        return Messages.getString("QImportOperation.importingPatch");
    }
}

