/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.operations;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.team.core.RepositoryProvider;

public class CreateProjectOperation
extends HgOperation {
    private final File projectFile;
    private final HgRepositoryLocation repo;
    private final boolean readProjectFile;
    private final String projectName;
    private IProject project;
    private final File projectDirectory;

    public CreateProjectOperation(IRunnableContext context, File projectDirectory, File projectFile, HgRepositoryLocation repo, boolean readProjectFile, String projectName) {
        super(context);
        this.projectFile = projectFile;
        this.repo = repo;
        this.readProjectFile = readProjectFile;
        this.projectName = projectName;
        this.projectDirectory = projectDirectory;
    }

    protected String getActionDescription() {
        return Messages.getString("CreateProjectOperation.taskDescription");
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.createProject(monitor);
            monitor.done();
        }
        catch (HgException e1) {
            throw new InvocationTargetException((Throwable)((Object)e1));
        }
    }

    private void createProject(IProgressMonitor monitor) throws HgException {
        InputStream in;
        block21: {
            in = null;
            if (!monitor.isCanceled()) break block21;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProjectDescription projectDesc = null;
                monitor.beginTask(Messages.getString("CreateProjectOperation.beginTask"), 15);
                if (this.readProjectFile && this.projectFile != null) {
                    monitor.subTask(Messages.getString("CreateProjectOperation.subTaskReadingProjectFile"));
                    in = new FileInputStream(this.projectFile);
                    projectDesc = workspace.loadProjectDescription(in);
                    monitor.worked(1);
                } else {
                    monitor.subTask(Messages.getString("CreateProjectOperation.subTaskCreatingProjectFile"));
                    projectDesc = workspace.newProjectDescription(this.projectName);
                    projectDesc.setComment(String.valueOf(Messages.getString("CloneRepoWizard.description.comment")) + this.repo);
                    monitor.worked(1);
                }
                if (!workspace.getRoot().getLocation().toFile().getAbsolutePath().equals(this.projectDirectory.getParentFile().getAbsolutePath())) {
                    projectDesc.setLocation((IPath)new Path(this.projectDirectory.getAbsolutePath()));
                } else {
                    projectDesc.setLocation(null);
                    if (!this.projectDirectory.getName().equals(projectDesc.getName())) {
                        String message = "Project directory name does not match project name from .project file! ";
                        message = String.valueOf(message) + "Directory name is '" + this.projectDirectory.getName() + "', ";
                        message = String.valueOf(message) + "project name is '" + projectDesc.getName() + "'! ";
                        message = String.valueOf(message) + "Using '" + this.projectDirectory.getName() + "' as project name!";
                        MercurialEclipsePlugin.logInfo(message, null);
                        projectDesc.setName(this.projectDirectory.getName());
                    }
                }
                IProject p = workspace.getRoot().getProject(projectDesc.getName());
                p.create(projectDesc, monitor);
                p.open(monitor);
                this.registerWithTeamProvider(p, monitor);
                this.project = p;
            }
            catch (HgException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new HgException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new HgException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void registerWithTeamProvider(IProject p, IProgressMonitor monitor) throws HgException {
        try {
            monitor.subTask(String.valueOf(Messages.getString("CloneRepoWizard.subTask.registeringProject1")) + p.getName() + Messages.getString("CloneRepoWizard.subTaskRegisteringProject2"));
            RepositoryProvider.map((IProject)p, (String)MercurialTeamProvider.class.getName());
            monitor.worked(1);
            monitor.subTask(String.valueOf(Messages.getString("CloneRepoWizard.subTask.addingRepository.1")) + this.repo + Messages.getString("CloneRepoWizard.subTask.addingRepository.2"));
            MercurialEclipsePlugin.getRepoManager().addRepoLocation(p, this.repo);
            monitor.worked(1);
        }
        catch (Exception e) {
            throw new HgException(e.getMessage(), e);
        }
    }

    public IProject getProject() {
        return this.project;
    }
}

