/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.model;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgIdentClient;
import com.vectrace.MercurialEclipse.commands.HgStatusClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.FlagManagerListener;
import com.vectrace.MercurialEclipse.model.FlaggedProject;
import com.vectrace.MercurialEclipse.model.FlaggedResource;
import com.vectrace.MercurialEclipse.model.Messages;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.RepositoryProvider;

public class FlagManager
implements IResourceChangeListener {
    private Map<IProject, FlaggedProject> projects = new HashMap<IProject, FlaggedProject>();
    private List<FlagManagerListener> listeners = new ArrayList<FlagManagerListener>();

    public FlagManager() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void addListener(FlagManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(FlagManagerListener listener) {
        this.listeners.remove(listener);
    }

    public FlaggedProject getFlaggedProject(IProject project) throws CoreException, HgException {
        if (project == null || RepositoryProvider.getProvider((IProject)project, (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") == null) {
            return null;
        }
        if (!this.projects.containsKey(project)) {
            this.refresh(project);
        }
        return this.projects.get(project);
    }

    public FlaggedProject refresh(IProject project) throws CoreException, HgException {
        String statusOutput = HgStatusClient.getStatus((IContainer)project);
        IContainer workspace = project.getParent();
        HashMap<IResource, FlaggedResource> statusMap = new HashMap<IResource, FlaggedResource>();
        Scanner scanner = new Scanner(statusOutput);
        while (scanner.hasNext()) {
            String status = scanner.next();
            String localName = scanner.nextLine();
            IFile member = project.getFile(localName.trim());
            BitSet bitSet = new BitSet();
            bitSet.set(this.getBitIndex(status.charAt(0)));
            statusMap.put((IResource)member, new FlaggedResource((IResource)member, bitSet));
            IContainer parent = member.getParent();
            while (parent != workspace) {
                FlaggedResource parentFlagged = (FlaggedResource)statusMap.get(parent);
                if (parentFlagged == null) {
                    statusMap.put((IResource)parent, new FlaggedResource((IResource)parent, bitSet));
                } else {
                    bitSet = parentFlagged.combineStatus(bitSet);
                }
                parent = parent.getParent();
            }
        }
        String version = HgIdentClient.getCurrentRevision((IContainer)project);
        project.getPersistentProperty(ResourceProperties.MERGING);
        FlaggedProject fp = new FlaggedProject(project, statusMap, version);
        this.projects.put(project, fp);
        for (FlagManagerListener listener : this.listeners) {
            listener.onRefresh(project);
        }
        return fp;
    }

    private final int getBitIndex(char status) {
        switch (status) {
            case '!': {
                return 2;
            }
            case 'R': {
                return 3;
            }
            case 'I': {
                return 0;
            }
            case 'C': {
                return 1;
            }
            case '?': {
                return 4;
            }
            case 'A': {
                return 5;
            }
            case 'M': {
                return 6;
            }
        }
        MercurialEclipsePlugin.logWarning(String.valueOf(Messages.getString("FlagManager.unknownStatus")) + status + "'", null);
        return 7;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        HashSet<IProject> changedProjects = new HashSet<IProject>();
        if (event.getType() == 1) {
            IResourceDelta[] children;
            IResourceDelta[] iResourceDeltaArray = children = event.getDelta().getAffectedChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta = iResourceDeltaArray[n2];
                IProject project = delta.getResource().getProject();
                if (RepositoryProvider.getProvider((IProject)project, (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") != null) {
                    changedProjects.add(project);
                }
                ++n2;
            }
        }
        for (IProject project : changedProjects) {
            try {
                this.refresh(project);
            }
            catch (Exception e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
    }
}

