/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.menu;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgIgnoreClient;
import com.vectrace.MercurialEclipse.dialogs.IgnoreDialog;
import com.vectrace.MercurialEclipse.menu.Messages;
import com.vectrace.MercurialEclipse.menu.SingleResourceHandler;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.TeamException;

public class HgIgnoreHandler
extends SingleResourceHandler {
    protected void run(IResource resource) throws Exception {
        IgnoreDialog dialog;
        switch (resource.getType()) {
            case 1: {
                dialog = new IgnoreDialog(this.getShell(), (IFile)resource);
                break;
            }
            case 2: {
                dialog = new IgnoreDialog(this.getShell(), (IFolder)resource);
                break;
            }
            default: {
                dialog = new IgnoreDialog(this.getShell());
            }
        }
        if (dialog.open() == 0) {
            switch (dialog.getResultType()) {
                case FILE: {
                    HgIgnoreClient.addFile(dialog.getFile());
                    break;
                }
                case EXTENSION: {
                    HgIgnoreClient.addExtension(dialog.getFile());
                    break;
                }
                case FOLDER: {
                    HgIgnoreClient.addFolder(dialog.getFolder());
                    break;
                }
                case GLOB: {
                    HgIgnoreClient.addGlob(resource.getProject(), dialog.getPattern());
                    break;
                }
                case REGEXP: {
                    HgIgnoreClient.addRegexp(resource.getProject(), dialog.getPattern());
                }
            }
            try {
                IProject project = resource.getProject();
                IFile hgIgnoreFile = project.getFile(".hgignore");
                hgIgnoreFile.refreshLocal(0, null);
                MercurialStatusCache.getInstance().refreshStatus(resource, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (TeamException e) {
                MercurialEclipsePlugin.logError(Messages.getString("HgIgnoreHandler.unableToRefreshProject"), e);
            }
        }
    }
}

