/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.history;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgLogClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgGLogClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgSigsClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.history.MercurialRevision;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.GChangeSet;
import com.vectrace.MercurialEclipse.model.Signature;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialHistory
extends FileHistory {
    private static final ChangeSetComparator csComparator = new ChangeSetComparator();
    private static final RevisionComparator revComparator = new RevisionComparator();
    private final IResource resource;
    private SortedSet<MercurialRevision> revisions;
    private Map<Integer, GChangeSet> gChangeSets;
    private int bottom;

    public MercurialHistory(IResource resource) {
        this.resource = resource;
    }

    public MercurialRevision getNext(MercurialRevision prev) {
        ArrayList<MercurialRevision> list = new ArrayList<MercurialRevision>(this.revisions);
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) == prev && i > 0) {
                return (MercurialRevision)((Object)list.get(i - 1));
            }
            ++i;
        }
        return null;
    }

    public MercurialRevision getPrev(MercurialRevision next) {
        ArrayList<MercurialRevision> list = new ArrayList<MercurialRevision>(this.revisions);
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) == next && i + 1 < list.size()) {
                return (MercurialRevision)((Object)list.get(i + 1));
            }
            ++i;
        }
        return null;
    }

    public int getBottom() {
        return this.bottom;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public IFileRevision[] getContributors(IFileRevision revision) {
        return null;
    }

    public IFileRevision getFileRevision(String id) {
        if (this.revisions == null || this.revisions.size() == 0) {
            return null;
        }
        for (MercurialRevision rev : this.revisions) {
            if (!rev.getContentIdentifier().equals(id)) continue;
            return rev;
        }
        return null;
    }

    public IFileRevision[] getFileRevisions() {
        if (this.revisions != null) {
            return (IFileRevision[])this.revisions.toArray(new MercurialRevision[this.revisions.size()]);
        }
        return new IFileRevision[0];
    }

    public IFileRevision[] getTargets(IFileRevision revision) {
        return new IFileRevision[0];
    }

    public void refresh(IProgressMonitor monitor, int from) throws CoreException {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)this.resource.getProject());
        if (!(provider instanceof MercurialTeamProvider)) {
            return;
        }
        if (from == Integer.MAX_VALUE && this.revisions != null) {
            this.revisions.clear();
        }
        TreeSet<ChangeSet> changeSets = new TreeSet<ChangeSet>(csComparator);
        int logBatchSize = Integer.parseInt(MercurialUtilities.getPreference("hg.batchsize.log", "500"));
        if (from == this.bottom || from < 0) {
            return;
        }
        Map<IPath, SortedSet<ChangeSet>> map = HgLogClient.getProjectLog(this.resource, logBatchSize, from, false);
        if (map == null) {
            this.bottom = from;
            return;
        }
        SortedSet<ChangeSet> localChangeSets = map.get(this.resource.getLocation());
        if (localChangeSets == null) {
            return;
        }
        File file = this.resource.getLocation().toFile();
        List<Signature> sigs = HgSigsClient.getSigs(file);
        HashMap<String, Signature> sigMap = new HashMap<String, Signature>();
        if (!MercurialUtilities.getGpgExecutable().equals("false")) {
            for (Signature signature : sigs) {
                sigMap.put(signature.getNodeId(), signature);
            }
        }
        changeSets.addAll(localChangeSets);
        if (this.revisions == null || this.revisions.size() == 0 || this.revisions.size() < changeSets.size() || !this.revisions.first().getResource().equals((Object)this.resource)) {
            this.revisions = new TreeSet<MercurialRevision>(revComparator);
            this.updateGraphData(changeSets);
        }
        for (ChangeSet cs : changeSets) {
            Signature sig = (Signature)sigMap.get(cs.getChangeset());
            this.revisions.add(new MercurialRevision(cs, this.gChangeSets.get(cs.getChangesetIndex()), this.resource, sig));
        }
    }

    private void updateGraphData(SortedSet<ChangeSet> changeSets) {
        this.gChangeSets = new HashMap<Integer, GChangeSet>();
        try {
            List<GChangeSet> gLogChangeSets = new HgGLogClient(this.resource).update(changeSets).getChangeSets();
            for (GChangeSet gs : gLogChangeSets) {
                if (gs == null) continue;
                this.gChangeSets.put(gs.getRev(), gs);
            }
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChangeSetComparator
    implements Comparator<ChangeSet>,
    Serializable {
        private static final long serialVersionUID = 6661721027440425773L;

        private ChangeSetComparator() {
        }

        @Override
        public int compare(ChangeSet o1, ChangeSet o2) {
            int dateCompare;
            int result = o2.getChangesetIndex() - o1.getChangesetIndex();
            if (result == 0 && o1.getDate() != null && o2.getDate() != null && (dateCompare = o2.getRealDate().compareTo(o1.getRealDate())) != 0) {
                result = dateCompare;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RevisionComparator
    implements Comparator<MercurialRevision>,
    Serializable {
        private static final long serialVersionUID = 5305190339206751711L;

        private RevisionComparator() {
        }

        @Override
        public int compare(MercurialRevision o1, MercurialRevision o2) {
            int dateCompare;
            int result = o2.getRevision() - o1.getRevision();
            if (result == 0 && o1.getChangeSet().getDate() != null && o2.getChangeSet().getDate() != null && (dateCompare = o2.getChangeSet().getRealDate().compareTo(o1.getChangeSet().getRealDate())) != 0) {
                result = dateCompare;
            }
            return result;
        }
    }
}

