/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.compare;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgParentClient;
import com.vectrace.MercurialEclipse.compare.RevisionNode;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.team.MercurialRevisionStorage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class HgCompareEditorInput
extends CompareEditorInput {
    private static final Differencer DIFFERENCER = new Differencer();
    private final ResourceNode left;
    private final ResourceNode ancestor;
    private final ResourceNode right;

    public HgCompareEditorInput(CompareConfiguration configuration, IResource resource, ResourceNode left, ResourceNode right) {
        super(configuration);
        this.left = left;
        this.ancestor = this.findParentNodeIfExists(resource, left, right);
        this.right = right;
        this.setTitle(resource.getName());
        configuration.setLeftLabel(left.getName());
        configuration.setLeftEditable(!(left instanceof RevisionNode));
        configuration.setRightLabel(right.getName());
        configuration.setRightEditable(false);
    }

    private ResourceNode findParentNodeIfExists(IResource resource, ResourceNode l, ResourceNode r) {
        int commonAncestor;
        block6: {
            int rId;
            block5: {
                if (!(l instanceof RevisionNode) || !(r instanceof RevisionNode)) {
                    return null;
                }
                int lId = ((RevisionNode)l).getRevision();
                rId = ((RevisionNode)r).getRevision();
                try {
                    commonAncestor = HgParentClient.findCommonAncestor(resource.getProject().getLocation().toFile(), Integer.toString(lId), Integer.toString(rId));
                    if (commonAncestor != lId) break block5;
                    return null;
                }
                catch (HgException e) {
                    MercurialEclipsePlugin.logError((Throwable)((Object)e));
                    return null;
                }
            }
            if (commonAncestor != rId) break block6;
            return null;
        }
        return new RevisionNode(new MercurialRevisionStorage(resource, commonAncestor));
    }

    public HgCompareEditorInput(CompareConfiguration configuration, IResource leftResource, ResourceNode ancestor, ResourceNode right, boolean localEditable) {
        super(configuration);
        this.left = new ResourceNode(leftResource);
        this.ancestor = ancestor;
        this.right = right;
        this.setTitle(this.left.getName());
        configuration.setLeftLabel(this.left.getName());
        configuration.setLeftEditable(localEditable);
        configuration.setAncestorLabel(ancestor.getName());
        configuration.setRightLabel(right.getName());
        configuration.setRightEditable(false);
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return DIFFERENCER.findDifferences(this.ancestor != null, monitor, null, (Object)this.ancestor, (Object)this.left, (Object)this.right);
    }

    public String getOKButtonLabel() {
        if (this.getCompareConfiguration().isLeftEditable() || this.getCompareConfiguration().isRightEditable()) {
            return "Save Changes";
        }
        return super.getOKButtonLabel();
    }

    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        boolean save = this.isSaveNeeded();
        super.saveChanges(monitor);
        if (save) {
            ((IFile)this.left.getResource()).setContents(this.left.getContents(), true, true, monitor);
        }
    }
}

