/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions.mq;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public class HgQImportClient
extends AbstractClient {
    public static String qimport(IResource resource, boolean force, boolean git, boolean existing, ChangeSet[] changesets, IPath patchFile) throws HgException {
        Assert.isNotNull((Object)resource);
        HgCommand command = new HgCommand("qimport", HgQImportClient.getWorkingDirectory(resource), true);
        command.setUsePreferenceTimeout("hg.timeout.clone");
        command.addOptions("--config", "extensions.hgext.mq=");
        if (force) {
            command.addOptions("--force");
        }
        if (git) {
            command.addOptions("--git");
        }
        if (changesets != null && changesets.length > 0) {
            command.addOptions("--rev", String.valueOf(changesets[changesets.length - 1].getChangeset()) + ":" + changesets[0].getChangeset());
        } else {
            Assert.isNotNull((Object)patchFile);
            if (existing) {
                command.addOptions("--existing");
            } else {
                command.addOptions("--name", patchFile.toOSString());
            }
        }
        return command.executeToString();
    }
}

