/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions.forest;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.commands.HgPushPullClient;
import com.vectrace.MercurialEclipse.commands.RefreshWorkspaceStatusJob;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.cache.RefreshJob;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class HgFpushPullClient
extends HgPushPullClient {
    public static String fpush(File forestRoot, HgRepositoryLocation repo, String revision, int timeout, File snapFile) throws CoreException {
        URI uri;
        HgCommand command = new HgCommand("fpush", forestRoot, true);
        command.setUsePreferenceTimeout("hg.timeout.push");
        if (snapFile != null) {
            try {
                command.addOptions("--snapfile", snapFile.getCanonicalPath());
            }
            catch (IOException e) {
                throw new HgException(e.getLocalizedMessage(), e);
            }
        }
        if (revision != null && revision.length() > 0) {
            command.addOptions("-r", revision.trim());
        }
        if ((uri = repo.getUri()) != null) {
            command.addOptions(uri.toASCIIString());
        } else {
            command.addOptions(repo.getLocation());
        }
        return new String(command.executeToBytes(timeout));
    }

    public static String fpull(File forestRoot, HgRepositoryLocation repo, boolean update, boolean timeout, ChangeSet changeset, boolean walkHg, File snapFile, boolean partial) throws HgException {
        String result;
        URI uri = repo.getUri();
        String pullSource = uri != null ? uri.toASCIIString() : repo.getLocation();
        HgCommand command = new HgCommand("fpull", forestRoot, true);
        if (update) {
            command.addOptions("--update");
        }
        if (changeset != null) {
            command.addOptions("--rev", changeset.getChangeset());
        }
        if (snapFile != null) {
            try {
                command.addOptions("--snapfile", snapFile.getCanonicalPath());
            }
            catch (IOException e) {
                throw new HgException(e.getLocalizedMessage(), e);
            }
        }
        if (walkHg) {
            command.addOptions("--walkhg", "true");
        }
        if (partial) {
            command.addOptions("--partial");
        }
        command.addOptions(pullSource);
        if (timeout) {
            command.setUsePreferenceTimeout("hg.timeout.pull");
            result = new String(command.executeToBytes());
        } else {
            result = new String(command.executeToBytes(Integer.MAX_VALUE));
        }
        Set<IProject> projects = MercurialEclipsePlugin.getRepoManager().getAllRepoLocationProjects(repo);
        for (final IProject project : projects) {
            if (update) {
                RefreshWorkspaceStatusJob job = new RefreshWorkspaceStatusJob(project);
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        new RefreshJob("Refreshing " + project.getName(), project, 7).schedule();
                    }
                });
                job.schedule();
                continue;
            }
            new RefreshJob("Refreshing " + project.getName(), project, 7).schedule();
        }
        return result;
    }
}

