/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions;

import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import java.net.URI;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgTransplantClient {
    public static String transplant(IProject project, List<String> nodeIds, HgRepositoryLocation repo, boolean branch, String branchName, boolean all, boolean merge, String mergeNodeId, boolean prune, String pruneNodeId, boolean continueLastTransplant, boolean filterChangesets, String filter) throws HgException {
        HgCommand command = new HgCommand("transplant", (IContainer)project, false);
        command.setUsePreferenceTimeout("hg.timeout.pull");
        command.addOptions("--config", "extensions.hgext.transplant=");
        if (continueLastTransplant) {
            command.addOptions("--continue");
        } else {
            command.addOptions("--log");
            if (branch) {
                command.addOptions("--branch");
                command.addOptions(branchName);
                if (all) {
                    command.addOptions("--all");
                }
            } else {
                command.addOptions("--source");
                URI uri = repo.getUri();
                if (uri != null) {
                    command.addOptions(uri.toASCIIString());
                } else {
                    command.addOptions(repo.getLocation());
                }
            }
            if (prune) {
                command.addOptions("--prune");
                command.addOptions(pruneNodeId);
            }
            if (merge) {
                command.addOptions("--merge");
                command.addOptions(mergeNodeId);
            }
            if (nodeIds != null && nodeIds.size() > 0) {
                for (String node : nodeIds) {
                    command.addOptions(node);
                }
            }
            if (filterChangesets) {
                command.addOptions("--filter", filter);
            }
        }
        return new String(command.executeToBytes());
    }
}

