/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeWorkspaceJob;
import com.vectrace.MercurialEclipse.commands.HgBranchClient;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public final class RefreshWorkspaceStatusJob
extends SafeWorkspaceJob {
    private final IProject project;

    public RefreshWorkspaceStatusJob(IProject project) {
        super("Refreshing status for project " + project.getName() + "...");
        this.project = project;
    }

    protected IStatus runSafe(IProgressMonitor monitor) {
        try {
            String branch = HgBranchClient.getActiveBranch(this.project.getLocation().toFile());
            this.project.setSessionProperty(ResourceProperties.HG_BRANCH, (Object)branch);
            this.project.setPersistentProperty(ResourceProperties.MERGING, null);
            this.project.setSessionProperty(ResourceProperties.MERGE_COMMIT_OFFERED, null);
            this.project.refreshLocal(2, monitor);
            return super.runSafe(monitor);
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
            return e.getStatus();
        }
    }
}

