/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.commands.RefreshWorkspaceStatusJob;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.team.cache.RefreshJob;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class HgUpdateClient {
    public static void update(final IProject project, String revision, boolean clean) throws HgException {
        HgCommand command = new HgCommand("update", (IContainer)project, false);
        command.setUsePreferenceTimeout("hg.timeout.update");
        if (revision != null) {
            command.addOptions("-r", revision);
        }
        if (clean) {
            command.addOptions("-C");
        }
        command.executeToBytes();
        RefreshWorkspaceStatusJob job = new RefreshWorkspaceStatusJob(project);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                new RefreshJob("Refreshing " + project.getName(), project, 1).schedule();
            }
        });
        job.schedule();
    }
}

