/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgStatusClient
extends AbstractClient {
    public static String getStatus(IContainer root) throws HgException {
        return HgStatusClient.getStatus(root.getLocation().toFile());
    }

    public static String getStatus(File root) throws HgException {
        HgCommand command = new HgCommand("status", root, true);
        command.addOptions("-marduic");
        command.setUsePreferenceTimeout("hg.timeout.status");
        return command.executeToString();
    }

    public static String getStatusWithoutIgnored(HgRoot root, IResource res) throws HgException {
        HgCommand command = new HgCommand("status", (File)root, true);
        command.addOptions("-marduc");
        command.setUsePreferenceTimeout("hg.timeout.status");
        if (res.getType() == 1) {
            command.addOptions(res.getLocation().toFile().getAbsolutePath());
        }
        return command.executeToString();
    }

    public static String[] getUntrackedFiles(IContainer root) throws HgException {
        HgCommand command = new HgCommand("status", root, true);
        command.setUsePreferenceTimeout("hg.timeout.status");
        command.addOptions("-u", "-n");
        return command.executeToString().split("\n");
    }

    public static boolean isDirty(List<? extends IResource> resources) throws HgException {
        HgCommand command = new HgCommand("status", true);
        command.setUsePreferenceTimeout("hg.timeout.status");
        command.addOptions("-mard");
        command.addFiles(resources);
        return command.executeToBytes().length != 0;
    }

    public static boolean isDirty(IProject project) throws HgException {
        HgCommand command = new HgCommand("status", (IContainer)project, true);
        command.setUsePreferenceTimeout("hg.timeout.status");
        command.addOptions("-mard");
        return command.executeToBytes().length != 0;
    }

    public static String getMergeStatus(IResource res) throws HgException {
        HgCommand command = new HgCommand("identify", HgStatusClient.getWorkingDirectory(res), true);
        command.addOptions("-i", "--debug");
        command.setUsePreferenceTimeout("hg.timeout.status");
        String versionIds = command.executeToString().trim();
        Pattern p = Pattern.compile("^[0-9a-z]+\\+([0-9a-z]+)\\+$", 8);
        Matcher m = p.matcher(versionIds);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public static String getStatusWithoutIgnored(HgRoot root, List<IResource> files) throws HgException {
        HgCommand command = new HgCommand("status", (File)root, true);
        command.setUsePreferenceTimeout("hg.timeout.status");
        command.addOptions("-marduc");
        command.addFiles(files);
        return command.executeToString();
    }

    public static String[] getDirtyFiles(HgRoot root, File file) throws HgException {
        HgCommand command = new HgCommand("status", (File)root, true);
        command.setUsePreferenceTimeout("hg.timeout.status");
        command.addOptions("-mard");
        String result = command.executeToString();
        if (result == null || result.length() == 0) {
            return new String[0];
        }
        String[] status = result.split("\n");
        int i = 0;
        while (i < status.length) {
            status[i] = status[i].substring(2);
            ++i;
        }
        return status;
    }

    public static File getPossibleSourcePath(HgRoot root, File file, int firstKnownRevision) throws HgException {
        HgCommand command = new HgCommand("status", (File)root, true);
        command.setUsePreferenceTimeout("hg.timeout.status");
        command.addOptions("-arC");
        command.addOptions("--rev");
        command.addOptions(String.valueOf(firstKnownRevision - 1) + ":" + firstKnownRevision);
        String result = command.executeToString();
        if (result == null || result.length() == 0) {
            return null;
        }
        String relativePath = root.toRelative(file);
        String[] statusAndFileNames = result.split("\n");
        int i = 0;
        while (i < statusAndFileNames.length) {
            if (i + 1 < statusAndFileNames.length && statusAndFileNames[i].endsWith(relativePath)) {
                return new File(root, statusAndFileNames[i + 1].trim());
            }
            ++i;
        }
        return null;
    }
}

