/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.Messages;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class HgRootClient
extends AbstractClient {
    private static final Map<File, HgRoot> roots = new HashMap<File, HgRoot>();

    public static HgRoot getHgRoot(File file) throws HgException {
        HgRoot testRoot;
        File dir = ResourceUtils.getFirstExistingDirectory(file);
        HgRoot hgRoot = roots.get(dir);
        if (hgRoot != null) {
            return hgRoot;
        }
        try {
            testRoot = new HgRoot(dir);
        }
        catch (IOException iOException) {
            throw new HgException(String.valueOf(Messages.getString("HgRootClient.error.cannotGetCanonicalPath")) + file.getName());
        }
        hgRoot = roots.get(testRoot);
        if (hgRoot != null) {
            roots.put(dir, hgRoot);
            return hgRoot;
        }
        File root = HgRootClient.findHgDir(testRoot);
        if (root == null) {
            throw new HgException(String.valueOf(file.getName()) + Messages.getString("HgRootClient.error.noRoot"));
        }
        try {
            hgRoot = new HgRoot(root);
        }
        catch (IOException iOException) {
            throw new HgException(String.valueOf(Messages.getString("HgRootClient.error.cannotGetCanonicalPath")) + file.getName());
        }
        roots.put(root, hgRoot);
        return hgRoot;
    }

    private static File findHgDir(File startDir) {
        FileFilter hg = new FileFilter(){

            public boolean accept(File path) {
                return path.getName().equalsIgnoreCase(".hg") && path.isDirectory();
            }
        };
        File root = startDir;
        File[] rootContent = root.listFiles(hg);
        while (rootContent != null && rootContent.length == 0) {
            if ((root = root.getParentFile()) == null) {
                return null;
            }
            rootContent = root.listFiles(hg);
        }
        if (rootContent != null) {
            return root;
        }
        return null;
    }
}

