/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractParseChangesetClient;
import com.vectrace.MercurialEclipse.commands.AbstractShellCommand;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.utils.PatchUtils;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.compare.patch.IFilePatch;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgOutgoingClient
extends AbstractParseChangesetClient {
    public static Map<IPath, SortedSet<ChangeSet>> getOutgoing(IResource res, HgRepositoryLocation repository) throws HgException {
        AbstractShellCommand command = HgOutgoingClient.getCommand(res);
        try {
            command.addOptions("--style", AbstractParseChangesetClient.getStyleFile(true).getCanonicalPath());
        }
        catch (IOException e) {
            throw new HgException(e.getLocalizedMessage(), e);
        }
        HgOutgoingClient.setRepository(repository, command);
        String result = HgOutgoingClient.getResult(command);
        if (result == null) {
            return new HashMap<IPath, SortedSet<ChangeSet>>();
        }
        Map<IPath, SortedSet<ChangeSet>> revisions = HgOutgoingClient.createMercurialRevisions(res, result, true, ChangeSet.Direction.OUTGOING, repository, null, HgOutgoingClient.getOutgoingPatches(res, repository));
        return revisions;
    }

    private static IFilePatch[] getOutgoingPatches(IResource res, HgRepositoryLocation repository) throws HgException {
        String outgoingPatch = HgOutgoingClient.getOutgoingPatch(res, repository);
        return PatchUtils.getFilePatches(outgoingPatch);
    }

    private static String getResult(AbstractShellCommand command) throws HgException {
        String result;
        block4: {
            try {
                result = command.executeToString();
                if (!result.endsWith("no changes found")) break block4;
                return null;
            }
            catch (HgException hg) {
                if (hg.getStatus().getCode() == 1) {
                    return null;
                }
                throw hg;
            }
        }
        return result;
    }

    private static AbstractShellCommand getCommand(IResource res) {
        HgCommand command = new HgCommand("outgoing", (IContainer)res.getProject(), false);
        command.setUsePreferenceTimeout("hg.timeout.pull");
        return command;
    }

    private static void setRepository(HgRepositoryLocation repository, AbstractShellCommand command) {
        URI uri = repository.getUri();
        if (uri != null) {
            command.addOptions(uri.toASCIIString());
        } else {
            command.addOptions(repository.getLocation());
        }
    }

    private static String getOutgoingPatch(IResource res, HgRepositoryLocation repository) throws HgException {
        AbstractShellCommand command = HgOutgoingClient.getCommand(res);
        command.addOptions("-p");
        HgOutgoingClient.setRepository(repository, command);
        return HgOutgoingClient.getResult(command);
    }
}

