/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractParseChangesetClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.compare.patch.IFilePatch;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgIncomingClient
extends AbstractParseChangesetClient {
    public static Map<IPath, SortedSet<ChangeSet>> getHgIncoming(IResource res, HgRepositoryLocation repository) throws HgException {
        File bundleFile;
        HgCommand command = new HgCommand("incoming", HgIncomingClient.getWorkingDirectory(res), false);
        command.setUsePreferenceTimeout("hg.timeout.pull");
        try {
            bundleFile = File.createTempFile("bundleFile-" + res.getProject().getName() + "-", ".tmp", null);
            bundleFile.deleteOnExit();
            command.addOptions("--debug", "--style", AbstractParseChangesetClient.getStyleFile(true).getCanonicalPath(), "--bundle", bundleFile.getCanonicalPath());
        }
        catch (IOException e) {
            throw new HgException(e.getMessage(), e);
        }
        URI uri = repository.getUri();
        if (uri != null) {
            command.addOptions(uri.toASCIIString());
        } else {
            command.addOptions(repository.getLocation());
        }
        try {
            String result = command.executeToString();
            if (result.trim().endsWith("no changes found")) {
                return new HashMap<IPath, SortedSet<ChangeSet>>();
            }
            Map<IPath, SortedSet<ChangeSet>> revisions = HgIncomingClient.createMercurialRevisions(res, result, true, ChangeSet.Direction.INCOMING, repository, bundleFile, new IFilePatch[0]);
            return revisions;
        }
        catch (HgException hg) {
            if (hg.getStatus().getCode() == 1) {
                return new HashMap<IPath, SortedSet<ChangeSet>>();
            }
            throw new HgException("Incoming comand failed for " + res + ". " + hg.getMessage(), (Throwable)((Object)hg));
        }
    }
}

