/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;

public class HgIdentClient
extends AbstractClient {
    public static String getCurrentRevision(IContainer root) throws HgException {
        HgCommand command = new HgCommand("identify", root, true);
        command.addOptions("-n", "-i");
        command.setUsePreferenceTimeout("hg.timeout.status");
        return command.executeToString().trim();
    }

    public static String getCurrentRevision(IResource resource) throws HgException {
        HgCommand command = new HgCommand("identify", HgIdentClient.getWorkingDirectory(resource), true);
        command.setUsePreferenceTimeout("hg.timeout.status");
        command.addOptions("-nibt");
        return command.executeToString().trim();
    }

    private static int getNextInt(byte[] b, int idx) {
        int result = 0;
        int i = 0;
        while (i < 4 && i + idx < b.length) {
            result = (result << 8) + (b[i + idx] & 0xFF);
            ++i;
        }
        return result;
    }

    static String getCurrentChangesetId(InputStream inputStream) throws HgException {
        int read;
        StringBuilder id = new StringBuilder(20);
        byte[] first20bytes = new byte[20];
        try {
            read = inputStream.read(first20bytes);
        }
        catch (IOException e) {
            throw new HgException(e.getMessage(), e);
        }
        int i = 0;
        while (i < read) {
            int next = HgIdentClient.getNextInt(first20bytes, i);
            String s = Integer.toHexString(next);
            int size = s.length();
            while (size < 8) {
                id.append('0');
                ++size;
            }
            id.append(s);
            i += 4;
        }
        return id.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String getCurrentChangesetId(HgRoot repository) throws HgException {
        Object object;
        FileInputStream reader;
        block16: {
            StringBuilder pathStr = new StringBuilder(repository.getAbsolutePath());
            pathStr.append(File.separator).append(".hg");
            pathStr.append(File.separator).append("dirstate");
            reader = null;
            try {
                reader = new FileInputStream(pathStr.toString());
            }
            catch (FileNotFoundException e) {
                object = HgIdentClient.class;
                // MONITORENTER : com.vectrace.MercurialEclipse.commands.HgIdentClient.class
                try {
                    HgIdentClient.class.wait(300L);
                }
                catch (InterruptedException e1) {
                    MercurialEclipsePlugin.logError(e1);
                }
                try {
                    reader = new FileInputStream(pathStr.toString());
                }
                catch (FileNotFoundException e1) {
                    MercurialEclipsePlugin.logError(e1);
                }
                if (reader != null) break block16;
                throw new HgException("Dirstate failed for the path: " + pathStr, e);
            }
        }
        try {
            object = HgIdentClient.getCurrentChangesetId(reader);
            return object;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
    }
}

