/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.dialogs.Messages;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.cache.RefreshJob;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgCommitClient
extends AbstractClient {
    public static void commitResources(List<IResource> resources, String user, String message, IProgressMonitor monitor) throws HgException {
        Map<HgRoot, List<IResource>> resourcesByRoot = ResourceUtils.groupByRoot(resources);
        for (Map.Entry<HgRoot, List<IResource>> mapEntry : resourcesByRoot.entrySet()) {
            HgRoot root = mapEntry.getKey();
            if (monitor != null) {
                if (monitor.isCanceled()) break;
                monitor.subTask(String.valueOf(Messages.getString("HgCommitClient.commitJob.committing")) + root.getName());
            }
            List<IResource> files = mapEntry.getValue();
            HgCommitClient.commit(root, AbstractClient.toFiles(files), user, message);
        }
        Map<IProject, List<IResource>> byProject = ResourceUtils.groupByProject(resources);
        Set<IProject> keySet = byProject.keySet();
        for (IProject project : keySet) {
            new RefreshJob("Refreshing " + project.getName(), project, 5).schedule();
        }
    }

    protected static String commit(HgRoot root, List<File> files, String user, String message) throws HgException {
        HgCommand command = new HgCommand("commit", (File)root, true);
        command.setUsePreferenceTimeout("hg.timeout.commit");
        command.addUserName(HgCommitClient.quote(user));
        command.addOptions("-m", HgCommitClient.quote(message));
        command.addFiles((Collection<String>)AbstractClient.toPaths(files));
        return command.executeToString();
    }

    static String quote(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return str.replaceAll("\"", "\\\\\"");
    }

    public static String commitProject(IProject project, String user, String message) throws HgException {
        HgCommand command = new HgCommand("commit", (IContainer)project, true);
        command.setUsePreferenceTimeout("hg.timeout.commit");
        command.addUserName(HgCommitClient.quote(user));
        command.addOptions("-m", HgCommitClient.quote(message));
        String result = command.executeToString();
        new RefreshJob("Refreshing " + project.getName(), project, 5).schedule();
        return result;
    }
}

