/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.commands.RefreshWorkspaceStatusJob;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.team.cache.RefreshJob;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class HgBackoutClient {
    public static String backout(final IProject project, ChangeSet backoutRevision, boolean merge, String msg, String user) throws CoreException {
        HgCommand command = new HgCommand("backout", (IContainer)project, true);
        boolean useExternalMergeTool = Boolean.valueOf(HgClients.getPreference("hg.merge.useExternal", "false"));
        if (!useExternalMergeTool) {
            command.addOptions("--config", "ui.merge=simplemerge");
        }
        command.addOptions("-r", backoutRevision.getChangeset(), "-m", msg, "-u", user);
        if (merge) {
            command.addOptions("--merge");
        }
        String result = command.executeToString();
        RefreshWorkspaceStatusJob job = new RefreshWorkspaceStatusJob(project);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                new RefreshJob("Refreshing " + project.getName(), project).schedule();
            }
        });
        job.schedule();
        return result;
    }
}

