/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.commands.Messages;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgAddClient
extends AbstractClient {
    public static void addResources(List<IResource> resources, IProgressMonitor monitor) throws HgException {
        Map<HgRoot, List<IResource>> resourcesByRoot = ResourceUtils.groupByRoot(resources);
        for (Map.Entry<HgRoot, List<IResource>> mapEntry : resourcesByRoot.entrySet()) {
            HgRoot root = mapEntry.getKey();
            if (monitor != null) {
                monitor.subTask(String.valueOf(Messages.getString("HgAddClient.addingResourcesFrom")) + root.getName());
            }
            int size = resources.size();
            int delta = 119;
            int i = 0;
            while (i < size) {
                HgCommand command = new HgCommand("add", (File)root, true);
                command.setUsePreferenceTimeout("hg.timeout.add");
                command.addFiles(mapEntry.getValue().subList(i, Math.min(i + delta, size)));
                command.executeToBytes();
                i += delta;
            }
        }
    }
}

