/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractShellCommand;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.commands.HgRootClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClient {
    protected static File getWorkingDirectory(IResource resource) {
        File file = ResourceUtils.getFileHandle(resource);
        return AbstractClient.getWorkingDirectory(file);
    }

    protected static File getWorkingDirectory(IPath path) {
        return AbstractClient.getWorkingDirectory(path.toFile());
    }

    protected static File getWorkingDirectory(File file) {
        return ResourceUtils.getFirstExistingDirectory(file);
    }

    public static HgRoot getHgRoot(IResource resource) throws HgException {
        File file = ResourceUtils.getFileHandle(resource);
        return HgRootClient.getHgRoot(file);
    }

    public static HgRoot getHgRoot(IPath path) throws HgException {
        return AbstractClient.getHgRoot(path.toFile());
    }

    public static HgRoot getHgRoot(File file) throws HgException {
        Assert.isNotNull((Object)file);
        return HgRootClient.getHgRoot(file);
    }

    static List<File> toFiles(List<IResource> files) {
        ArrayList<File> toFiles = new ArrayList<File>();
        for (IResource r : files) {
            toFiles.add(r.getLocation().toFile());
        }
        return toFiles;
    }

    static List<String> toPaths(List<File> files) {
        ArrayList<String> paths = new ArrayList<String>();
        for (File f : files) {
            paths.add(f.getAbsolutePath());
        }
        return paths;
    }

    public static boolean isCommandAvailable(String commandName, String extensionEnabler) {
        boolean returnValue = false;
        HgCommand command = new HgCommand("help", null, false);
        if (extensionEnabler != null && extensionEnabler.length() != 0) {
            command.addOptions("--config", "extensions." + extensionEnabler);
        }
        command.addOptions(commandName);
        try {
            String result = new String(command.executeToBytes(10000, false));
            returnValue = !result.startsWith("hg: unknown command");
        }
        catch (HgException hgException) {
            returnValue = false;
        }
        return returnValue;
    }

    protected static void addRepoToHgCommand(HgRepositoryLocation repo, AbstractShellCommand cmd) {
        URI uri = repo.getUri();
        if (uri != null) {
            cmd.addOptions(uri.toASCIIString());
        } else {
            cmd.addOptions(repo.getLocation());
        }
    }
}

