/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.annotations;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeUiJob;
import com.vectrace.MercurialEclipse.annotations.AnnotateBlock;
import com.vectrace.MercurialEclipse.annotations.AnnotateBlocks;
import com.vectrace.MercurialEclipse.annotations.AnnotateCommand;
import com.vectrace.MercurialEclipse.annotations.CommitterColors;
import com.vectrace.MercurialEclipse.annotations.Messages;
import com.vectrace.MercurialEclipse.annotations.SourceViewerInformationControl;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.HgFile;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.SortedSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.TeamOperation;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class ShowAnnotationOperation
extends TeamOperation {
    private static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private final HgFile remoteFile;
    private final IResource res;

    public ShowAnnotationOperation(IWorkbenchPart part, HgFile remoteFile) throws HgException {
        super(part);
        this.remoteFile = remoteFile;
        this.res = ResourceUtils.convert(remoteFile);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(null, 100);
        try {
            if (!MercurialStatusCache.getInstance().isSupervised(this.res, (IPath)new Path(this.remoteFile.getCanonicalPath()))) {
                return;
            }
            try {
                AnnotateBlocks annotateBlocks = new AnnotateCommand(this.remoteFile).execute();
                final RevisionInformation information = this.createRevisionInformation(annotateBlocks, monitor);
                new SafeUiJob(Messages.getString("ShowAnnotationOperation.job.name")){

                    protected IStatus runSafe(IProgressMonitor moni) {
                        moni.beginTask(Messages.getString("ShowAnnotationOperation.beginAnnotation"), -1);
                        AbstractDecoratedTextEditor editor = ShowAnnotationOperation.this.getEditor();
                        if (editor != null) {
                            editor.showRevisionInformation(information, "com.vectrace.MercurialEclipse.annotatations.HgReferenceProvider");
                        }
                        moni.done();
                        return super.runSafe(moni);
                    }
                }.schedule();
            }
            catch (Exception e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IAction getGotoAction() {
        return super.getGotoAction();
    }

    private AbstractDecoratedTextEditor getEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IEditorReference[] references = window.getActivePage().getEditorReferences();
        IResource resource = this.res;
        if (resource == null) {
            return null;
        }
        int i = 0;
        while (i < references.length) {
            IEditorReference reference = references[i];
            try {
                if (resource != null && resource.equals(reference.getEditorInput().getAdapter(IFile.class))) {
                    IEditorPart editor = reference.getEditor(false);
                    if (editor instanceof AbstractDecoratedTextEditor) {
                        return (AbstractDecoratedTextEditor)editor;
                    }
                    IEditorPart part = this.getPart().getSite().getPage().openEditor((IEditorInput)new FileEditorInput((IFile)resource), DEFAULT_TEXT_EDITOR_ID, true, 0);
                    if (part != null && part instanceof AbstractDecoratedTextEditor) {
                        return (AbstractDecoratedTextEditor)part;
                    }
                }
            }
            catch (PartInitException partInitException) {}
            ++i;
        }
        try {
            IEditorPart part;
            IEditorDescriptor descrptr = IDE.getEditorDescriptor((IFile)((IFile)resource));
            if (descrptr.isInternal()) {
                part = IDE.openEditor((IWorkbenchPage)this.getPart().getSite().getPage(), (IFile)((IFile)resource));
                if (part instanceof AbstractDecoratedTextEditor) {
                    return (AbstractDecoratedTextEditor)part;
                }
                this.getPart().getSite().getPage().closeEditor(part, false);
            }
            if ((part = IDE.openEditor((IWorkbenchPage)this.getPart().getSite().getPage(), (IFile)((IFile)resource), (String)DEFAULT_TEXT_EDITOR_ID)) != null && part instanceof AbstractDecoratedTextEditor) {
                return (AbstractDecoratedTextEditor)part;
            }
        }
        catch (PartInitException partInitException) {}
        return null;
    }

    private RevisionInformation createRevisionInformation(AnnotateBlocks annotateBlocks, IProgressMonitor monitor) throws HgException {
        HashMap<Integer, ChangeSet> logEntriesByRevision = new HashMap<Integer, ChangeSet>();
        LocalChangesetCache.getInstance().refreshAllLocalRevisions(this.res, true);
        SortedSet<ChangeSet> revisions = LocalChangesetCache.getInstance().getLocalChangeSets(this.res);
        for (ChangeSet changeSet : revisions) {
            logEntriesByRevision.put(changeSet.getRevision().getRevision(), changeSet);
        }
        RevisionInformation info = new RevisionInformation();
        try {
            Class<?> infoClass = info.getClass();
            Class[] paramTypes = new Class[]{IInformationControlCreator.class};
            Method method1 = infoClass.getMethod("setHoverControlCreator", paramTypes);
            Method method2 = infoClass.getMethod("setInformationPresenterControlCreator", paramTypes);
            final class AnnotationControlCreator
            implements IInformationControlCreator {
                private final String statusFieldText;

                public AnnotationControlCreator(String statusFieldText) {
                    this.statusFieldText = statusFieldText;
                }

                public IInformationControl createInformationControl(Shell parent) {
                    return new SourceViewerInformationControl(parent, 4, 0, "org.eclipse.jface.defaultfont", this.statusFieldText);
                }
            }
            method1.invoke((Object)info, new AnnotationControlCreator(Messages.getString("ShowAnnotationOperation.pressF2ForFocus")));
            method2.invoke((Object)info, new AnnotationControlCreator(null));
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
        }
        CommitterColors colors = CommitterColors.getDefault();
        HashMap<String, Revision> sets = new HashMap<String, Revision>();
        for (AnnotateBlock block : annotateBlocks.getAnnotateBlocks()) {
            String revisionString = block.getRevision().toString();
            ChangeSet logEntry = (ChangeSet)logEntriesByRevision.get(block.getRevision().getRevision());
            Revision revision = (Revision)sets.get(revisionString);
            if (revision == null) {
                revision = new MercurialRevision(colors, logEntry, revisionString, block);
                sets.put(revisionString, revision);
                info.addRevision(revision);
            }
            revision.addRange((ILineRange)new LineRange(block.getStartLine(), block.getEndLine() - block.getStartLine() + 1));
        }
        return info;
    }

    private static final class MercurialRevision
    extends Revision {
        private final CommitterColors colors;
        private final ChangeSet entry;
        private final String string;
        private final AnnotateBlock block;

        private MercurialRevision(CommitterColors colors, ChangeSet entry, String string, AnnotateBlock block) {
            this.colors = colors;
            this.entry = entry;
            this.string = string;
            this.block = block;
        }

        public Object getHoverInfo() {
            return String.valueOf(this.block.getUser()) + " " + this.string + " " + DateFormat.getDateTimeInstance(2, 3).format(this.block.getDate()) + "\n\n" + (this.entry != null ? this.entry.getDescription() : "");
        }

        public String getAuthor() {
            return this.block.getUser();
        }

        public String getId() {
            return this.string;
        }

        public Date getDate() {
            return this.block.getDate();
        }

        public RGB getColor() {
            return this.colors.getCommitterRGB(this.getAuthor());
        }
    }
}

