/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.annotations;

import com.vectrace.MercurialEclipse.HgRevision;
import com.vectrace.MercurialEclipse.annotations.AnnotateBlock;
import com.vectrace.MercurialEclipse.annotations.AnnotateBlocks;
import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgFile;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class AnnotateCommand {
    private static final Pattern ANNOTATE = Pattern.compile("^\\s*(.+[^ ])\\s+(\\w+)\\s+(\\w+)\\s+(\\w+ \\w+ \\w+ \\w+:\\w+:\\w+ \\w+ [\\+\\-]\\w+).*: (.*)$");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy Z", Locale.ENGLISH);
    private final HgFile file;

    public AnnotateCommand(HgFile file) {
        this.file = file;
    }

    public AnnotateBlocks execute() throws HgException {
        IFile resource = (IFile)ResourceUtils.convert(this.file);
        if (!MercurialUtilities.hgIsTeamProviderFor((IResource)resource, true)) {
            return null;
        }
        HgRoot root = AbstractClient.getHgRoot((IResource)resource);
        String relPath = root.toRelative(resource.getLocation().toFile());
        String[] launchCmd = new String[]{MercurialUtilities.getHGExecutable(), "annotate", "--user", "--number", "--changeset", "--date", "--", relPath};
        String output = MercurialUtilities.executeCommand(launchCmd, root, true);
        if (output == null) {
            return null;
        }
        return AnnotateCommand.createFromStdOut(new StringReader(output));
    }

    protected static AnnotateBlocks createFromStdOut(InputStream contents) {
        return AnnotateCommand.createFromStdOut(new InputStreamReader(contents));
    }

    protected static synchronized AnnotateBlocks createFromStdOut(Reader contents) {
        AnnotateBlocks blocks = new AnnotateBlocks();
        try {
            String line;
            BufferedReader reader = new BufferedReader(contents);
            int count = 0;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                Matcher matcher = ANNOTATE.matcher(line);
                matcher.find();
                String author = matcher.group(1);
                int revision = Integer.parseInt(matcher.group(2));
                String changeset = matcher.group(3);
                Date date = DATE_FORMAT.parse(matcher.group(4));
                blocks.add(new AnnotateBlock(new HgRevision(changeset, revision), author, date, count, count));
                ++count;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return blocks;
    }
}

