/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.actions;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeUiJob;
import com.vectrace.MercurialEclipse.actions.Messages;
import com.vectrace.MercurialEclipse.team.MercurialRevisionStorage;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class OpenMercurialRevisionAction
extends BaseSelectionListenerAction {
    private IStructuredSelection selection;
    private HistoryPage page;

    public OpenMercurialRevisionAction(String text) {
        super(text);
    }

    public void run() {
        IStructuredSelection structSel = this.selection;
        Object[] objArray = structSel.toArray();
        int i = 0;
        while (i < objArray.length) {
            Object tempRevision = objArray[i];
            final IFileRevision revision = (IFileRevision)tempRevision;
            if (revision == null || !revision.exists()) {
                MessageDialog.openError((Shell)this.page.getSite().getShell(), (String)Messages.getString("OpenMercurialRevisionAction.error.deletedRevision"), (String)Messages.getString("OpenMercurialRevisionAction.error.cantOpen"));
            } else {
                SafeUiJob runnable = new SafeUiJob(Messages.getString("OpenMercurialRevisionAction.job.openingEditor")){

                    public IStatus runSafe(IProgressMonitor monitor) {
                        try {
                            IStorage file = revision.getStorage(monitor);
                            String id = OpenMercurialRevisionAction.this.getEditorID(file.getName(), file.getContents());
                            if (file instanceof IFile) {
                                IDE.openEditor((IWorkbenchPage)OpenMercurialRevisionAction.this.page.getSite().getPage(), (IFile)((IFile)file));
                            } else {
                                MercurialRevisionEditorInput fileRevEditorInput = new MercurialRevisionEditorInput(revision);
                                if (!OpenMercurialRevisionAction.this.editorAlreadyOpenOnContents(fileRevEditorInput)) {
                                    OpenMercurialRevisionAction.this.page.getSite().getPage().openEditor((IEditorInput)fileRevEditorInput, id);
                                }
                            }
                            return super.runSafe(monitor);
                        }
                        catch (CoreException e) {
                            MercurialEclipsePlugin.logError(e);
                            return e.getStatus();
                        }
                    }
                };
                runnable.schedule();
            }
            ++i;
        }
    }

    String getEditorID(String fileName, InputStream contents) {
        IEditorDescriptor descriptor;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry registry = workbench.getEditorRegistry();
        IContentType type = null;
        if (contents != null) {
            try {
                type = Platform.getContentTypeManager().findContentTypeFor(contents, fileName);
            }
            catch (IOException e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
        if (type == null) {
            type = Platform.getContentTypeManager().findContentTypeFor(fileName);
        }
        String id = (descriptor = registry.getDefaultEditor(fileName, type)) == null || descriptor.isOpenExternal() ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
        return id;
    }

    protected boolean updateSelection(IStructuredSelection selection1) {
        this.selection = selection1;
        return this.shouldShow();
    }

    public void setPage(HistoryPage page) {
        this.page = page;
    }

    private boolean shouldShow() {
        IStructuredSelection structSel = this.selection;
        Object[] objArray = structSel.toArray();
        if (objArray.length == 0) {
            return false;
        }
        int i = 0;
        while (i < objArray.length) {
            IFileRevision revision = (IFileRevision)objArray[i];
            if (revision != null && !revision.exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean editorAlreadyOpenOnContents(MercurialRevisionEditorInput input) {
        IEditorReference[] editorRefs = this.page.getSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IFileRevision editorRevision;
            IFileRevision inputRevision;
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null && part.getEditorInput() instanceof MercurialRevisionEditorInput && (inputRevision = (IFileRevision)input.getAdapter(IFileRevision.class)).equals(editorRevision = (IFileRevision)part.getEditorInput().getAdapter(IFileRevision.class))) {
                this.page.getSite().getPage().activate((IWorkbenchPart)part);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class MercurialRevisionEditorInput
    extends PlatformObject
    implements IWorkbenchAdapter,
    IStorageEditorInput {
        private final IFileRevision fileRevision;
        private MercurialRevisionStorage storage;

        public MercurialRevisionEditorInput(IFileRevision revision) {
            this.fileRevision = revision;
            try {
                this.storage = (MercurialRevisionStorage)revision.getStorage((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                MercurialEclipsePlugin.logError(e);
            }
        }

        public Object[] getChildren(Object o) {
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            if (this.storage != null) {
                return this.storage.getName();
            }
            return "";
        }

        public Object getParent(Object o) {
            return null;
        }

        public IStorage getStorage() throws CoreException {
            return this.storage;
        }

        public boolean exists() {
            return true;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            String ret = "";
            if (this.fileRevision != null) {
                ret = String.valueOf(this.fileRevision.getName()) + "[" + this.storage.getChangeSet().toString() + "]";
            } else if (this.storage != null) {
                ret = String.valueOf(this.storage.getName()) + " " + DateFormat.getInstance().format(new Date(((IFileState)this.storage).getModificationTime()));
            }
            return ret;
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            if (this.fileRevision != null) {
                try {
                    return this.getStorage().getFullPath().toString();
                }
                catch (CoreException e) {
                    MercurialEclipsePlugin.logError(e);
                }
            }
            if (this.storage != null) {
                return this.storage.getFullPath().toString();
            }
            return "";
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IWorkbenchAdapter.class) {
                return this;
            }
            if (adapter == IFileRevision.class) {
                return this.fileRevision;
            }
            if (adapter == IFileState.class && this.storage != null && this.storage instanceof IFileState) {
                return this.storage;
            }
            return super.getAdapter(adapter);
        }
    }
}

