/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse;

import com.vectrace.MercurialEclipse.DefaultConfiguration;
import com.vectrace.MercurialEclipse.Messages;
import com.vectrace.MercurialEclipse.SafeUiJob;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgDebugInstallClient;
import com.vectrace.MercurialEclipse.storage.HgCommitMessageManager;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocationManager;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MercurialEclipsePlugin
extends AbstractUIPlugin {
    public static final String ID = "com.vectrace.MercurialEclipse";
    public static final String ID_ChangeLogView = "com.vectrace.MercurialEclipse.views.ChangeLogView";
    public static final String BUNDLE_FILE_PREFIX = "bundlefile";
    private static MercurialEclipsePlugin plugin;
    private static HgRepositoryLocationManager repoManager;
    private static HgCommitMessageManager commitMessageManager;
    private boolean hgUsable = true;

    static {
        repoManager = new HgRepositoryLocationManager();
        commitMessageManager = new HgCommitMessageManager();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        DefaultConfiguration cfg = new DefaultConfiguration();
        HgClients.initialize(cfg, cfg, cfg);
        new Job("Starting MercurialEclipse."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Starting MercurialEclipse", 3);
                    monitor.subTask("Checking Mercurial installation.");
                    MercurialEclipsePlugin.this.checkHgInstallation();
                    monitor.done();
                    monitor.subTask("Loading known Mercurial repositories.");
                    repoManager.start();
                    monitor.worked(1);
                    monitor.subTask("Starting Commit Message manager.");
                    commitMessageManager.start();
                    monitor.worked(1);
                    monitor.done();
                    return new Status(0, MercurialEclipsePlugin.ID, "MercurialEclipse started successfully.");
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.this.hgUsable = false;
                    MercurialEclipsePlugin.logError(Messages.getString("MercurialEclipsePlugin.unableToStart"), e);
                    return new Status(4, MercurialEclipsePlugin.ID, e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }.schedule();
    }

    public void checkHgInstallation() {
        try {
            this.hgUsable = true;
            MercurialUtilities.getHGExecutable(true);
            String result = HgDebugInstallClient.debugInstall();
            if (result.endsWith("No problems detected")) {
                this.hgUsable = true;
                return;
            }
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            MercurialEclipsePlugin.showError(e);
            this.hgUsable = false;
        }
    }

    public static HgRepositoryLocationManager getRepoManager() {
        return repoManager;
    }

    public static HgCommitMessageManager getCommitMessageManager() {
        return commitMessageManager;
    }

    public static void setCommitMessageManager(HgCommitMessageManager commitMessageManager) {
        MercurialEclipsePlugin.commitMessageManager = commitMessageManager;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            repoManager.stop();
            commitMessageManager.stop();
            plugin = null;
        }
        finally {
            super.stop(context);
        }
    }

    public static MercurialEclipsePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)("icons/" + path));
    }

    public static final void logError(String message, Throwable error) {
        MercurialEclipsePlugin.getDefault().getLog().log(MercurialEclipsePlugin.createStatus(message, 0, 4, error));
    }

    public static void showError(final Throwable error) {
        new SafeUiJob(Messages.getString("MercurialEclipsePlugin.showError")){

            protected IStatus runSafe(IProgressMonitor monitor) {
                IStatus status = error instanceof CoreException ? ((CoreException)error).getStatus() : MercurialEclipsePlugin.createStatus(error.getMessage(), 0, 4, error);
                ErrorDialog.openError(null, (String)Messages.getString("MercurialEclipsePlugin.unexpectedError"), (String)error.getMessage(), (IStatus)status);
                return super.runSafe(monitor);
            }
        }.schedule();
    }

    public static final void logWarning(String message, Throwable error) {
        MercurialEclipsePlugin.getDefault().getLog().log(MercurialEclipsePlugin.createStatus(message, 0, 2, error));
    }

    public static final void logInfo(String message, Throwable error) {
        MercurialEclipsePlugin.getDefault().getLog().log(MercurialEclipsePlugin.createStatus(message, 0, 1, error));
    }

    public static IStatus createStatus(String msg, int code, int severity, Throwable ex) {
        return new Status(severity, ID, code, msg, ex);
    }

    public static final void logError(Throwable ex) {
        MercurialEclipsePlugin.logError(ex.getMessage(), ex);
    }

    public static void runWithProgress(Shell parent, boolean cancelable, final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        boolean createdShell = false;
        Shell myParent = parent;
        try {
            if (myParent == null || myParent.isDisposed()) {
                Display display = Display.getCurrent();
                if (display == null) {
                    runnable.run((IProgressMonitor)new NullProgressMonitor());
                    return;
                }
                myParent = display.getActiveShell();
                if (myParent == null) {
                    myParent = new Shell(display);
                    createdShell = true;
                }
            }
            final Exception[] holder = new Exception[1];
            BusyIndicator.showWhile((Display)myParent.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e) {
                        holder[0] = e;
                    }
                    catch (InterruptedException e) {
                        holder[0] = e;
                    }
                }
            });
            if (holder[0] != null) {
                if (holder[0] instanceof InvocationTargetException) {
                    throw (InvocationTargetException)holder[0];
                }
                throw (InterruptedException)holder[0];
            }
        }
        finally {
            if (createdShell) {
                parent.dispose();
            }
        }
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public boolean isHgUsable() {
        return this.hgUsable;
    }

    public static Display getStandardDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }
}

