/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.wizards;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.wizards.BaseSQLPage;
import com.quantum.wizards.CommonWizardUI;
import com.quantum.wizards.SQLPage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ViewRowPage
extends BaseSQLPage
implements SQLPage {
    String[] columnNames;
    String[] colNames;
    Table table;
    Text query;
    ViewRowTableValues[] viewTable = null;
    CommonWizardUI comUI;
    TableViewer tableViewer = null;
    int numColumns = 0;
    static Image imgCheck = null;
    static Image imgUncheck = null;

    static {
        imgCheck = ImageStore.getImage("checked");
        imgUncheck = ImageStore.getImage("unchecked");
    }

    public ViewRowPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("TableView.ViewRowTitle"));
        this.setDescription(Messages.getString("TableView.ViewRowDesc"));
    }

    public void createControl(Composite parent) {
        System.out.println("page create control");
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1810));
        this.comUI = new CommonWizardUI();
        this.columnNames = this.results.getColumnNames();
        int nLen = this.columnNames.length;
        this.viewTable = new ViewRowTableValues[nLen];
        int nCtr = 0;
        while (nCtr < nLen) {
            this.viewTable[nCtr] = new ViewRowTableValues();
            this.viewTable[nCtr].setColNames(this.columnNames[nCtr]);
            Object data = this.row == null ? null : this.row.get(nCtr + 1);
            this.viewTable[nCtr].setValues(data == null ? "" : data.toString());
            ++nCtr;
        }
        this.createTable(container);
        this.query = new Text(container, 586);
        this.query.setLayoutData((Object)this.comUI.createGridData(1, 10, 4));
        this.query.setVisible(true);
        this.setControl((Control)container);
        this.setPageComplete(true);
    }

    public void updateQuery() {
        System.out.println("Updating query");
        this.query.setText(this.viewTable[this.table.getSelectionIndex()].getValues());
    }

    protected String getQueryText() {
        return this.query.getText();
    }

    private void createTable(Composite composite) {
        System.out.println("Creating table...");
        this.table = this.comUI.createTablePage(composite);
        this.colNames = new String[]{Messages.getString("InsertRowPage.ColumnName"), Messages.getString("InsertRowPage.Value")};
        this.comUI.createTableColumn(this.table, this.colNames[0], 16384, 0, 200);
        this.comUI.createTableColumn(this.table, this.colNames[1], 16384, 1, 400);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setColumnProperties(this.colNames);
        CellEditor[] editor = new CellEditor[this.colNames.length];
        TextCellEditor txtEditorField = new TextCellEditor((Composite)this.table);
        txtEditorField.getControl().setEnabled(false);
        editor[0] = txtEditorField;
        TextCellEditor txtEditorValues = new TextCellEditor((Composite)this.table);
        txtEditorValues.getControl().setEnabled(false);
        editor[1] = txtEditorValues;
        this.tableViewer.setCellEditors(editor);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.tableViewer.setContentProvider((IContentProvider)new ContentProviderImpl());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifierImpl());
        this.tableViewer.setInput((Object)this.viewTable);
    }

    private void updateView() {
        this.tableViewer.update((Object[])this.viewTable, null);
    }

    class ViewRowTableValues {
        private String colNames = null;
        private String values = null;
        private boolean defaultVal = false;
        private boolean noQuote = false;

        public boolean isNoQuote() {
            return this.noQuote;
        }

        public void setNoQuote(boolean noQuote) {
            this.noQuote = noQuote;
        }

        public String getColNames() {
            return this.colNames;
        }

        public void setColNames(String colNames) {
            this.colNames = colNames;
        }

        public String getValues() {
            return this.values;
        }

        public void setValues(String values) {
            this.values = values;
        }

        public boolean isDefaultVal() {
            return this.defaultVal;
        }

        public void setDefaultVal(boolean defaultVal) {
            this.defaultVal = defaultVal;
        }
    }

    class LabelProviderImpl
    implements ITableLabelProvider {
        LabelProviderImpl() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String sReturn = "";
            ViewRowTableValues viewRow = (ViewRowTableValues)element;
            switch (columnIndex) {
                case 0: {
                    sReturn = viewRow.getColNames();
                    break;
                }
                case 1: {
                    sReturn = viewRow.getValues();
                    break;
                }
            }
            return sReturn;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class ContentProviderImpl
    implements IStructuredContentProvider {
        ContentProviderImpl() {
        }

        public Object[] getElements(Object inputElement) {
            return ViewRowPage.this.viewTable;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class CellModifierImpl
    implements ICellModifier {
        CellModifierImpl() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            int colIndx = ViewRowPage.this.comUI.getColumnNamesAsList(ViewRowPage.this.colNames).indexOf(property);
            String rResult = null;
            ViewRowTableValues viewVal = (ViewRowTableValues)element;
            switch (colIndx) {
                case 0: {
                    rResult = viewVal.getColNames();
                    break;
                }
                case 1: {
                    rResult = viewVal.getValues();
                    break;
                }
            }
            return rResult;
        }

        public void modify(Object element, String property, Object value) {
            int colIndx = ViewRowPage.this.comUI.getColumnNamesAsList(ViewRowPage.this.colNames).indexOf(property);
            TableItem item = (TableItem)element;
            ViewRowTableValues cfr_ignored_0 = (ViewRowTableValues)item.getData();
            switch (colIndx) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
            }
            ViewRowPage.this.updateQuery();
        }
    }
}

