/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.wizards;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.model.Column;
import com.quantum.model.Entity;
import com.quantum.util.StringMatrix;
import com.quantum.wizards.BaseSQLPage;
import com.quantum.wizards.CommonWizardUI;
import com.quantum.wizards.SQLPage;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DeleteRowPage
extends BaseSQLPage
implements SQLPage {
    String[] columnNames;
    String[] colNames;
    Text query;
    DeleteRowPageValues[] deleteTable = null;
    CommonWizardUI comUI;
    TableViewer tableViewer = null;
    static Image imgCheck = null;
    static Image imgUncheck = null;

    static {
        imgCheck = ImageStore.getImage("checked");
        imgUncheck = ImageStore.getImage("unchecked");
    }

    public DeleteRowPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("TableView.DeleteRowTitle"));
        this.setDescription(Messages.getString("TableView.DeleteRowDesc"));
    }

    public void createControl(Composite parent) {
        System.out.println("page create control");
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1810));
        Entity entity = this.results.getEntity();
        this.comUI = new CommonWizardUI();
        this.columnNames = this.results.getColumnNames();
        int nLen = this.columnNames.length;
        this.deleteTable = new DeleteRowPageValues[nLen];
        int nCtr = 0;
        while (nCtr < nLen) {
            Column column;
            this.deleteTable[nCtr] = new DeleteRowPageValues();
            this.deleteTable[nCtr].setSColNames(this.columnNames[nCtr]);
            Object data = this.row == null ? null : this.row.get(nCtr + 1);
            this.deleteTable[nCtr].setSValues(data == null ? "" : data.toString());
            Column column2 = column = entity == null ? null : this.getColumn(entity, this.columnNames[nCtr]);
            if (column != null && column.isPrimaryKey()) {
                this.deleteTable[nCtr].setBPrimary(true);
            }
            ++nCtr;
        }
        this.createTable(container);
        this.query = new Text(container, 586);
        this.query.setLayoutData((Object)this.comUI.createGridData(1, 10, 4));
        this.query.setVisible(false);
        this.setControl((Control)container);
        this.updateQuery();
        this.setPageComplete(true);
    }

    public void updateQuery() {
        System.out.println(Messages.getString("DeleteRowPage.UpdatingQuery"));
        this.query.setVisible(true);
        StringMatrix key = new StringMatrix();
        ArrayList<Boolean> noQuoteKey = new ArrayList<Boolean>();
        int i = 0;
        while (i < this.columnNames.length) {
            if (this.deleteTable[i].isBPrimary()) {
                key.addHeader(this.deleteTable[i].getSColNames());
                key.add(this.deleteTable[i].getSValues(), 0);
                noQuoteKey.add(new Boolean(this.deleteTable[i].isNoQuoteKey()));
            }
            ++i;
        }
        Bookmark bookmark = (Bookmark)this.results.getConnectable();
        DatabaseAdapter adapter = bookmark.getAdapter();
        this.query.setText(adapter.buildDelete(this.results.getEntity(), key, noQuoteKey));
    }

    protected String getQueryText() {
        return this.query.getText();
    }

    private void updateView() {
        this.tableViewer.update((Object[])this.deleteTable, null);
    }

    private void createTable(Composite composite) {
        System.out.println("Creating table...");
        Table table = this.comUI.createTablePage(composite);
        this.colNames = new String[]{Messages.getString("DeleteRowPage.ColumnName"), Messages.getString("DeleteRowPage.Value"), "Where", "No Quote"};
        this.comUI.createTableColumn(table, this.colNames[0], 16384, 0, 150);
        this.comUI.createTableColumn(table, this.colNames[1], 16384, 1, 300);
        this.comUI.createTableColumn(table, this.colNames[2], 0x1000000, 2, 60);
        this.comUI.createTableColumn(table, this.colNames[3], 0x1000000, 3, 60);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setColumnProperties(this.colNames);
        CellEditor[] editor = new CellEditor[this.colNames.length];
        TextCellEditor txtEditorField = new TextCellEditor((Composite)table);
        txtEditorField.getControl().setEnabled(false);
        editor[0] = txtEditorField;
        TextCellEditor txtEditorFieldValue = new TextCellEditor((Composite)table);
        editor[1] = txtEditorFieldValue;
        editor[2] = new CheckboxCellEditor((Composite)table, 0);
        editor[3] = new CheckboxCellEditor((Composite)table, 0);
        this.tableViewer.setCellEditors(editor);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.tableViewer.setContentProvider((IContentProvider)new ContentProviderImpl());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifierImpl());
        this.tableViewer.setInput((Object)this.deleteTable);
    }

    class DeleteRowPageValues {
        private String sColNames = null;
        private String sValues = null;
        private boolean bPrimary = false;
        private boolean noQuoteKey = false;

        public boolean isNoQuoteKey() {
            return this.noQuoteKey;
        }

        public void setNoQuoteKey(boolean noQuoteKey) {
            this.noQuoteKey = noQuoteKey;
        }

        public boolean isBPrimary() {
            return this.bPrimary;
        }

        public void setBPrimary(boolean primary) {
            this.bPrimary = primary;
        }

        public String getSColNames() {
            return this.sColNames;
        }

        public void setSColNames(String colNames) {
            this.sColNames = colNames;
        }

        public String getSValues() {
            return this.sValues;
        }

        public void setSValues(String values) {
            this.sValues = values;
        }
    }

    class LabelProviderImpl
    implements ITableLabelProvider {
        LabelProviderImpl() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 2) {
                return ((DeleteRowPageValues)element).isBPrimary() ? imgCheck : imgUncheck;
            }
            if (columnIndex == 3) {
                return ((DeleteRowPageValues)element).isNoQuoteKey() ? imgCheck : imgUncheck;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String sReturn = "";
            DeleteRowPageValues deleteRow = (DeleteRowPageValues)element;
            switch (columnIndex) {
                case 0: {
                    sReturn = deleteRow.getSColNames();
                    break;
                }
                case 1: {
                    sReturn = deleteRow.getSValues();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
            return sReturn;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class ContentProviderImpl
    implements IStructuredContentProvider {
        ContentProviderImpl() {
        }

        public Object[] getElements(Object inputElement) {
            return DeleteRowPage.this.deleteTable;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class CellModifierImpl
    implements ICellModifier {
        CellModifierImpl() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            System.out.println("getValue called");
            int colIndx = DeleteRowPage.this.comUI.getColumnNamesAsList(DeleteRowPage.this.colNames).indexOf(property);
            System.out.println("colIndx : " + colIndx);
            Object rResult = null;
            DeleteRowPageValues deleteVal = (DeleteRowPageValues)element;
            switch (colIndx) {
                case 0: {
                    rResult = deleteVal.getSColNames();
                    break;
                }
                case 1: {
                    rResult = deleteVal.getSValues();
                    break;
                }
                case 2: {
                    rResult = new Boolean(deleteVal.isBPrimary());
                    break;
                }
                case 3: {
                    rResult = new Boolean(deleteVal.isNoQuoteKey());
                    break;
                }
            }
            return rResult;
        }

        public void modify(Object element, String property, Object value) {
            int colIndx = DeleteRowPage.this.comUI.getColumnNamesAsList(DeleteRowPage.this.colNames).indexOf(property);
            TableItem item = (TableItem)element;
            DeleteRowPageValues deleteVal = (DeleteRowPageValues)item.getData();
            switch (colIndx) {
                case 0: {
                    break;
                }
                case 1: {
                    deleteVal.setSValues(value.toString());
                    break;
                }
                case 2: {
                    deleteVal.setBPrimary((Boolean)value);
                    break;
                }
                case 3: {
                    deleteVal.setNoQuoteKey((Boolean)value);
                    break;
                }
            }
            DeleteRowPage.this.updateView();
            DeleteRowPage.this.updateQuery();
        }
    }
}

