/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.wizards;

import com.quantum.Messages;
import com.quantum.model.BookmarkCollection;
import com.quantum.wizards.PropertyChangeWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BookmarkNameWizardPage
extends PropertyChangeWizardPage {
    private String name;
    private final String originalName;

    public BookmarkNameWizardPage(String pageName) {
        this(pageName, null);
    }

    public BookmarkNameWizardPage(String pageName, String originalName) {
        super(pageName);
        this.originalName = originalName;
        this.setTitle(Messages.getString(((Object)((Object)this)).getClass(), "title"));
        this.setDescription(Messages.getString(((Object)((Object)this)).getClass(), "description"));
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString(((Object)((Object)this)).getClass(), "name"));
        Text name = new Text(composite, 2052);
        GridData data = new GridData(768);
        name.setLayoutData((Object)data);
        if (this.originalName != null) {
            name.setText(this.originalName);
        }
        name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String name = ((Text)event.getSource()).getText();
                BookmarkNameWizardPage.this.setName(name);
            }
        });
        this.setControl((Control)composite);
    }

    private void setName(String bookmarkName) {
        String errorMessage = null;
        boolean done = true;
        if (bookmarkName == null || bookmarkName.trim().length() == 0) {
            errorMessage = Messages.getString(((Object)((Object)this)).getClass(), "mustProvide");
            done = false;
        } else if (this.originalName != null && this.originalName.equals(bookmarkName)) {
            done = false;
        } else if (BookmarkCollection.getInstance().find(bookmarkName) != null) {
            errorMessage = Messages.getString(((Object)((Object)this)).getClass(), "alreadyExists");
            done = false;
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(done);
        if (errorMessage == null && !bookmarkName.equals(this.name)) {
            String original = this.name;
            this.name = bookmarkName;
            this.firePropertyChange("name", original, bookmarkName);
        }
    }

    public String getName() {
        return this.name;
    }
}

